package com.geoway.jckj.biz.service.login.impl;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.jckj.base.support.Pair;
import com.geoway.jckj.biz.dto.SmsCaptchaDTO;
import com.geoway.jckj.biz.service.login.ICaptchaService;
import com.geoway.jckj.biz.service.login.ISmsCaptchaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author 连世忠
 * @ClassName SmsCaptchaServiceImpl
 * @Description TODO
 * @date 2025/6/10 15:38
 * @Version 1.0
 */
@Service
public class SmsCaptchaServiceImpl implements ISmsCaptchaService {
    @Autowired
    ICaptchaService captchaService;
    @Override
    public String createCaptcha(int size) {
        return RandomUtil.randomNumbers(6);
    }

    @Override
    public SmsCaptchaDTO storeCaptcha(String sessionId, String smsCode) {
        Long timeStamp = System.currentTimeMillis();
        // 将验证码存到redis中,同时存入创建时间
        SmsCaptchaDTO smsCaptchaDTO=new SmsCaptchaDTO();
        smsCaptchaDTO.setVerifyCode(smsCode);
        smsCaptchaDTO.setCreateTime(timeStamp);
        smsCaptchaDTO.setVerifyed(false);
        smsCaptchaDTO.setLeft(3);
        smsCaptchaDTO.setUid(sessionId);
        // 将认证码存入redis
        captchaService.storeCaptcha(sessionId, JSONUtil.toJsonStr(smsCaptchaDTO));
        return smsCaptchaDTO;
    }

    @Override
    public Pair<Boolean, String> validateCaptcha(String sessionId,String verifyCode) {
        Pair<Boolean, String> result = null;
        final long SMS_CODE_OUT_DATE = 5 * 60 * 1000;
        String smsCodeObj = captchaService.queryCaptcha(sessionId);
        // 获取session中验证码
        JSONObject smsCodeJson = null;
        if (smsCodeObj != null) {
            smsCodeJson = JSON.parseObject(smsCodeObj.toString());
            int left = smsCodeJson.getIntValue("left");

            if (left <= 0) {
                result = new Pair<>(false, "验证码失效，请重新发送验证码！");
                return result;
            }
            if (System.currentTimeMillis() - Long.parseLong(smsCodeJson.getString("createTime"))
                    > SMS_CODE_OUT_DATE) {
                result = new Pair<>(false, "验证码失效，请重新发送验证码！");
                return result;
            }
            if (!verifyCode.equalsIgnoreCase(smsCodeJson.getString("verifyCode"))) {
                left = left - 1;
                smsCodeJson.put("left", left);
                captchaService.storeCaptcha(sessionId, smsCodeJson.toString());
                result = new Pair<>(false, "验证码错误，请重试！");
                return result;
            } else {
                smsCodeJson.put("isVerifyed", true);
                captchaService.storeCaptcha(sessionId, smsCodeJson.toString());
                result = new Pair<>(true, "验证成功！");
                return result;
            }
        } else {
            result = new Pair<>(false, "验证码错误！");
            return result;
        }
    }


}
