package com.geoway.jckj.biz.service.login.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.biz.entity.SysApp;
import com.geoway.jckj.biz.mapper.SysAppMapper;
import com.geoway.jckj.biz.service.login.ISsoAppService;
import com.geoway.sso.client.rpc.Result;
import org.springframework.stereotype.Service;

/**
 * @author ALMJ
 * @desc 应用权限验证逻辑
 */
@Service
public class SsoAppServiceImpl extends ServiceImpl<SysAppMapper, SysApp> implements ISsoAppService {

    @Override
    public boolean exists(String appId) {
        return this.count(Wrappers.lambdaQuery(SysApp.class).eq(SysApp::getAppid, appId)) > 0;
    }

    @Override
    public Result<Void> validate(String appId, String appSecret) {
        SysApp sysApp = this.getOne(Wrappers.lambdaQuery(SysApp.class).eq(SysApp::getAppid, appId));
        if (sysApp == null) {
            return Result.createError("appId不存在");
        }
        if (!appSecret.equals(sysApp.getAppsercet())) {
            return Result.createError("appSecret有误");
        }
        return Result.success();
    }
}
