package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.biz.dto.RoleSystemsDTO;
import com.geoway.jckj.biz.entity.*;
import com.geoway.jckj.biz.mapper.SysRoleMapper;
import com.geoway.jckj.biz.mapper.SysRoleMenuMapper;
import com.geoway.jckj.biz.mapper.SysRoleSystemMapper;
import com.geoway.jckj.biz.mapper.SysSystemMapper;
import com.geoway.jckj.biz.service.sys.SysRoleSystemService;
import com.geoway.jckj.biz.util.SaasEntityUtil;
import com.geoway.jckj.biz.util.SysSystemUtil;
import com.geoway.jckj.biz.util.TenantUtil;
import com.github.yulichang.toolkit.JoinWrappers;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
* @author daidongdong
* @description 针对表【sys_role_application(角色应用权限表)】的数据库操作Service实现
* @createDate 2024-10-15 17:25:14
*/
@Service
@Transactional
public class SysRoleSystemServiceImpl extends ServiceImpl<SysRoleSystemMapper, SysRoleSystem>
    implements SysRoleSystemService {


    @Autowired
    SysSystemMapper sysSystemMapper;
    @Autowired
    SysRoleMapper sysRoleMapper;
    @Autowired
    SysRoleMenuMapper sysRoleMenuMapper;

    @Override
    public void saveRoleSystems(String roleId, List<String> systemIds,  boolean isClear) {
        if(systemIds == null || systemIds.size() == 0 ){
            return;
        }
        //先删除后增加
        if(isClear){
            LambdaQueryWrapper<SysRoleSystem> wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysRoleSystem::getRoleid, roleId);
            this.remove(wrapper);
        }
        List<SysRoleSystem> roleSystems=new ArrayList<>();
        systemIds.forEach(systemId->{
            SysRoleSystem roleApp = new SysRoleSystem();
            roleApp.setSystemid(systemId);
            roleApp.setRoleid(roleId);

            roleSystems.add(roleApp);
        });
        this.saveBatch(roleSystems);
    }


    @Override
    public List<SysSystem> queryRoleSystems(String roleId) {
        MPJLambdaWrapper<SysSystem> queryWrapper = MPJWrappers.lambdaJoin();
        queryWrapper.leftJoin(SysRoleSystem.class,SysRoleSystem::getSystemid, SysSystem::getId);
        queryWrapper.eq(SysRoleSystem::getRoleid,roleId);

        //queryWrapper.leftJoin(SysUser.class, SysUser::getId, SysSystem::getCreatorid);
        queryWrapper.selectAll(SysSystem.class);
        //queryWrapper.selectAs(SysUser::getAname,SysSystem::getCreatorname);

        List<SysSystem> sysSystems= sysSystemMapper.selectJoinList(SysSystem.class,queryWrapper);
        SysSystemUtil.wrapper(sysSystems);
        return sysSystems;
    }

    @Override
    public RoleSystemsDTO queryRoleSystemDTOs(String roleId) {

        List<SysSystem> systems = this.queryRoleSystems(roleId);

        RoleSystemsDTO roleSystemsDTO = new RoleSystemsDTO();
        roleSystemsDTO.setRoleId(roleId);
        roleSystemsDTO.setSystems(systems);

        return roleSystemsDTO;
    }

    @Override
    public void removeRoleSystem(String roleId, List<String> systemIds) {
        for(String systemId: systemIds){
            this.removeRoleSystem(roleId,systemId);
        }
    }

    @Override
    public void removeRoleSystem(String roleId, String systemId) {
        MPJLambdaWrapper<SysRoleMenu>  joinQueryWrapper = JoinWrappers.lambda();
        joinQueryWrapper.leftJoin(SysMenu.class, SysMenu::getId, SysRoleMenu::getMenuid);
        joinQueryWrapper.eq(SysMenu::getSystemId,systemId);
        joinQueryWrapper.eq(SysRoleMenu::getRoleid, roleId);

        List<SysRoleMenu> roleMenus = sysRoleMenuMapper.selectJoinList(SysRoleMenu.class,joinQueryWrapper);
        if(roleMenus.size() > 0){
            List<String> roleMenuIds = roleMenus.stream().map( i -> i.getId()).collect(Collectors.toList());
            sysRoleMenuMapper.deleteBatchIds(roleMenuIds);
        }

        LambdaQueryWrapper<SysRoleSystem> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysRoleSystem::getRoleid, roleId);
        queryWrapper.eq(SysRoleSystem::getSystemid,systemId);
        this.remove(queryWrapper);
    }

    @Override
    public void saveSystemRoles(String systemId, String roleIds) {
        List<SysRole> sysRoles=systemRelateRoles(systemId);
        //先删除后增加
        LambdaQueryWrapper<SysRoleSystem> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysRoleSystem::getSystemid, systemId);
        if(sysRoles.size()>0){
            //每个租户的角色列表是不一样的
            wrapper.in(SysRoleSystem::getRoleid,sysRoles.stream().collect(Collectors.toList()));
        }
        this.remove(wrapper);

        if(StrUtil.isNotBlank(roleIds)){
            List<SysRoleSystem> roleApps=new ArrayList<>();
            Arrays.asList(roleIds.split(",")).forEach(roleId->{
                SysRoleSystem roleApp = new SysRoleSystem();
                roleApp.setSystemid(systemId);
                roleApp.setRoleid(roleId);

                roleApps.add(roleApp);
            });
            this.saveBatch(roleApps);
        }
    }

    @Override
    public List<SysRole> systemRelateRoles(String systemId) {
        MPJLambdaWrapper<SysRole> queryWrapper = MPJWrappers.lambdaJoin();
        queryWrapper.leftJoin(SysRoleSystem.class,SysRoleSystem::getRoleid, SysRole::getId);
        queryWrapper.eq(SysRoleSystem::getSystemid,systemId);
        queryWrapper.eq(SysRole::getTenantid, TenantUtil.getTenantId());
        List<SysRole> roles= sysRoleMapper.selectJoinList(SysRole.class,queryWrapper);
        SaasEntityUtil.wrapper(roles);
        return roles;
    }
}




