package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.lang.tree.TreeNodeConfig;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.base.support.BaseTreeUtil;
import com.geoway.jckj.base.support.StringUtils;
import com.geoway.jckj.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.jckj.base.support.spring.SpringUtils;
import com.geoway.jckj.biz.entity.*;
import com.geoway.jckj.biz.mapper.SysSubFunctionMapper;
import com.geoway.jckj.biz.service.sys.SysMenuService;
import com.geoway.jckj.biz.service.sys.SysSubFunctionService;
import com.geoway.jckj.biz.util.TenantUtil;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 *
 */
@Service
public class SysSubFunctionServiceImpl extends MPJBaseServiceImpl<SysSubFunctionMapper, SysSubFunction>
        implements SysSubFunctionService {
    final String rootPid = "0";
    private final TreeNodeConfig treeNodeConfig =
            new TreeNodeConfig().setParentIdKey("pid").setIdKey("id");


    @Override
    public void batchSave(List<SysSubFunction> sysSubFunctions) {
        if(sysSubFunctions.size()==0){
            return;
        }
        LambdaQueryWrapper<SysSubFunction> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysSubFunction::getSystemId, sysSubFunctions.get(0).getSystemId());
        wrapper.eq(SysSubFunction::getMenuId, sysSubFunctions.get(0).getMenuId());
        List<SysSubFunction> exsistFunctions=this.list(wrapper);
        sysSubFunctions.removeIf(f->exsistFunctions.stream().anyMatch(g->g.getName().equalsIgnoreCase(f.getName())
                                                                      ||g.getKey().equalsIgnoreCase(f.getKey())));
        if(sysSubFunctions.size()==0){
            return;
        }
        this.saveBatch(sysSubFunctions);

    }

    @Override
    public void saveOrUp(SysSubFunction subFunction) throws Exception {
        //判断名称是否重复
        LambdaQueryWrapper<SysSubFunction> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysSubFunction::getName, subFunction.getName());
        wrapper.eq(SysSubFunction::getSystemId, subFunction.getSystemId());
        wrapper.eq(SysSubFunction::getMenuId, subFunction.getMenuId());
        int iCount = this.count(wrapper);
        if (iCount > 0) {
            throw new Exception("功能点: " + subFunction.getName() + "  已存在！");
        }
        this.saveOrUpdate(subFunction);
    }



    @Override
    public List<SysSubFunction> query(String filterParam) throws Exception {
        MyBatisQueryMapperUtils<SysSubFunction> qmu = new MyBatisQueryMapperUtils<>();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysSubFunction.class);
        List<SysSubFunction> list = this.list(queryWrapper);
        // 构造树
        List<SysSubFunction> trees = BaseTreeUtil.listToTree(list, treeNodeConfig, rootPid);
        return trees;
    }

    @Override
    public List<SysSubFunction> queryByMenuId(String menuId)  {
        //获取到注册的菜单
        SysMenuService sysMenuService= SpringUtils.getBean(SysMenuService.class);
        SysMenu registerMenu=sysMenuService.queryRegisterMenu(menuId);
        if(registerMenu==null){
            return new ArrayList<>();
        }
        String curTenantId= TenantUtil.getTenantId();
        MPJLambdaWrapper<SysSubFunction> wrapper = MPJWrappers.lambdaJoin();
        wrapper.eq(SysSubFunction::getMenuId,registerMenu.getId());
        if (StringUtils.isNotEmpty(curTenantId)&&!registerMenu.getTenantid().equals(curTenantId)) {
            wrapper.leftJoin(SysTenantSubFunction.class, SysTenantSubFunction::getSubfunctionid,SysSubFunction::getId);
            wrapper.eq(SysTenantSubFunction::getTenantid,curTenantId);
            wrapper.distinct();
        }

        List<SysSubFunction> list = this.list(wrapper);
        // 构造树
        List<SysSubFunction> trees = BaseTreeUtil.listToTree(list, treeNodeConfig, rootPid);
        return trees;
    }

    @Override
    public void batchDelete(String ids) throws Exception {
        List<String> idList = Arrays.asList(ids.split(","));
        for (String id : idList) {
            LambdaQueryWrapper<SysSubFunction> wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysSubFunction::getPid, id);
            int iCount = this.count(wrapper);
            if (iCount > 0) {
                throw new Exception("功能点: " + id + "  存在子功能点，无法删除！");
            }
        }
        this.removeByIds(idList);
    }
}




