package com.geoway.jckj.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.sso.client.enums.RoleLevelEnum;
import com.geoway.jckj.biz.entity.SysUserCatalog;
import com.geoway.jckj.biz.mapper.SysUserCatalogMapper;
import com.geoway.jckj.biz.service.sys.SysUserCatalogService;
import com.github.yulichang.base.MPJBaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author 连世忠
 * @ClassName SysUserLevelServiceImpl
 * @Description TODO
 * @date 2025/5/7 14:39
 * @Version 1.0
 */
@Service
public class SysUserCatalogServiceImpl extends MPJBaseServiceImpl<SysUserCatalogMapper, SysUserCatalog> implements SysUserCatalogService {
    @Override
    public Integer getUserCatalog(String userId) {
        LambdaQueryWrapper<SysUserCatalog> queryWrapper =  Wrappers.lambdaQuery();
        queryWrapper.eq(SysUserCatalog::getUserid,userId);
        SysUserCatalog sysUserCatalog=this.getOne(queryWrapper,false);
        if(sysUserCatalog!=null){
            return sysUserCatalog.getUserCatalog();
        }
        return RoleLevelEnum.commonUser.getValue();
    }
    @Override
    public void saveOrUp(SysUserCatalog sysUserCatalog){
        LambdaQueryWrapper<SysUserCatalog> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserCatalog::getUserid, sysUserCatalog.getUserid());
        SysUserCatalog oldUserLevel=this.getOne(wrapper,false);
        if(oldUserLevel!=null){
            oldUserLevel.setUserCatalog(sysUserCatalog.getUserCatalog());
            this.updateById(oldUserLevel);
        }else{
            this.save(sysUserCatalog);
        }
    }

    @Override
    public List<String> getUserIdByCatalog(RoleLevelEnum roleLevel) {
        LambdaQueryWrapper<SysUserCatalog> queryWrapper =  Wrappers.lambdaQuery();
        queryWrapper.eq(SysUserCatalog::getUserCatalog,roleLevel.getValue());
        List<SysUserCatalog> list=this.list(queryWrapper);
        return list.stream().map(f->f.getUserid()).collect(Collectors.toList());
    }

}
