package com.geoway.jckj.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.biz.util.TenantUtil;
import com.geoway.sso.client.annotation.OpLog;
import com.geoway.jckj.biz.entity.SysUserRegion;
import com.geoway.jckj.biz.mapper.SysUserRegionMapper;
import com.geoway.jckj.biz.service.sys.SysUserRegionService;
import com.geoway.sso.client.enums.OpTypeEnum;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
* @author daidongdong
* @description 针对表【sys_user_region】的数据库操作Service实现
* @createDate 2022-01-20 15:44:01
*/
@Service
public class SysUserRegionServiceImpl extends ServiceImpl<SysUserRegionMapper, SysUserRegion>
    implements SysUserRegionService {

    @Override
    @OpLog(name = "修改用户所属辖区", opType = OpTypeEnum.update)
    public void updateUserRegions(String userId, List<String> regions) {
        //判断名称是否重复
        LambdaQueryWrapper<SysUserRegion> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserRegion::getUserid,userId);
        if(!TenantUtil.isSuperTenant()){
           if(TenantUtil.getTenantRegionIds().size()>0) {
               wrapper.in(SysUserRegion::getRegionid, TenantUtil.getTenantRegionIds());
           }else{
               wrapper.eq(SysUserRegion::getRegionid, UUID.randomUUID().toString());
           }
        }
        //先移除
        this.remove(wrapper);
        if(regions == null){
            return;
        }
        List<SysUserRegion> userRegions = new ArrayList<>();
        for(String regionId: regions){
            SysUserRegion userRegion = new SysUserRegion();
            userRegion.setUserid(userId);
            userRegion.setRegionid(regionId);
            userRegions.add(userRegion);
        }
        if(userRegions.size() > 0){
            this.saveBatch(userRegions);
        }
    }
}




