package com.geoway.jckj.biz.util;

import cn.hutool.core.util.StrUtil;
import com.geoway.jckj.base.support.spring.SpringUtils;
import com.geoway.jckj.biz.entity.BaseEntity;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserService;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author 连世忠
 * @ClassName BaseEntityUtil
 * @Description TODO
 * @date 2025/5/8 9:04
 * @Version 1.0
 */
public class BaseEntityUtil {
    public  static <T extends  BaseEntity> void wrapper(List<T> entities){
      IUnityUserService unityUserService= SpringUtils.getBean(IUnityUserService.class);
      List<SysUser> sysUsers=unityUserService.query(entities.stream().map(f->f.getCreatorid()).collect(Collectors.toList()));
      for(T entity:entities){
          SysUser sysUser=sysUsers.stream().filter(f->f.getId().equals(entity.getCreatorid())).findAny().orElse(null);
          if(sysUser!=null){
              entity.setCreatorname(sysUser.getAname());
          }
      }
    }
}
