/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.geoway.jckj.base.support.StringUtils;
import com.geoway.jckj.biz.entity.SaasEntity;
import com.geoway.jckj.biz.entity.SysRole;
import com.geoway.jckj.biz.entity.SysRoleSystem;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.entity.SysUserRole;
import com.geoway.jckj.biz.mapper.SysRoleMapper;
import com.geoway.jckj.biz.mapper.SysRoleSystemMapper;
import com.geoway.jckj.biz.service.ISaasEntityService;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserService;
import com.geoway.jckj.biz.service.oauth2.IOauth2Service;
import com.geoway.jckj.biz.service.sys.SysRoleService;
import com.geoway.jckj.biz.service.sys.SysUserRoleService;
import com.geoway.jckj.biz.util.SaasEntityUtil;
import com.geoway.jckj.biz.util.SysUserUtil;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysRoleServiceImpl
extends MPJBaseServiceImpl<SysRoleMapper, SysRole>
implements SysRoleService,
ISaasEntityService<SysRole> {
    final String rootPid = "0";
    private final TreeNodeConfig treeNodeConfig = new TreeNodeConfig().setParentIdKey("pid").setWeightKey("sort").setIdKey("id");
    @Autowired
    private IUnityUserService userService;
    @Autowired
    SysUserRoleService sysUserRoleService;
    @Autowired
    IOauth2Service auth2Service;
    @Autowired
    SysRoleSystemMapper sysRoleSystemMapper;
    @Autowired
    SysRoleMapper sysRoleMapper;

    @Override
    public void saveOrUp(SysRole role) throws Exception {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysRole::getName, (Object)role.getName());
        wrapper.eq(SysRole::getPid, (Object)role.getPid());
        wrapper.eq(SaasEntity::getTenantid, (Object)(StrUtil.isBlank((CharSequence)role.getTenantid()) ? this.getTenantId() : role.getTenantid()));
        if (StrUtil.isNotBlank((CharSequence)role.getId())) {
            wrapper.ne(SysRole::getId, (Object)role.getId());
            SysRole oldRole = (SysRole)this.getById((Serializable)((Object)role.getId()));
            if (oldRole != null) {
                role.setCreateTime(oldRole.getCreateTime());
                role.setLevel(oldRole.getLevel());
                role.setSort(oldRole.getSort());
                role.setCreatorid(oldRole.getCreatorid());
            }
            if (!oldRole.getName().equals(role.getName())) {
                this.buildChildALlName(role);
            }
        } else {
            SysRole pRole = (SysRole)this.getById((Serializable)((Object)role.getPid()));
            int level = pRole == null ? 1 : pRole.getLevel() + 1;
            role.setLevel(level);
            LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(SysRole::getPid, (Object)role.getPid());
            queryWrapper.orderByDesc(SysRole::getSort);
            queryWrapper.last(" limit 1");
            SysRole lastRole = (SysRole)this.getOne((Wrapper)queryWrapper);
            if (lastRole == null) {
                role.setSort(1);
            } else {
                role.setSort(lastRole.getSort() + 1);
            }
            this.wrapperEntity(role);
        }
        int iCount = this.count((Wrapper)wrapper);
        if (iCount > 0) {
            String typeStr = "\u89d2\u8272";
            if (role.getType() == 0) {
                typeStr = typeStr + "\u7ec4";
            }
            throw new Exception(typeStr + "\u3010" + role.getName() + "\u3011\u5df2\u5b58\u5728\uff01");
        }
        this.buildAllName(role);
        this.saveOrUpdate(role);
    }

    @Override
    public List<SysRole> queryTree(String filterParam) throws Exception {
        MPJLambdaWrapper<SysRole> wrapper = this.buildLambdaWrapper(filterParam, "");
        wrapper.eq(SysRole::getType, (Object)0);
        List list = this.sysRoleMapper.selectList((Wrapper)wrapper);
        if (filterParam == null) {
            filterParam = "";
        }
        MPJLambdaWrapper<SysRole> queryWrapper = this.buildLambdaWrapper(filterParam, "");
        queryWrapper.eq(SysRole::getType, (Object)1);
        List roleList = this.list((Wrapper)queryWrapper);
        list.addAll(roleList);
        List<SysRole> roleTrees = this.constructTree(list);
        return roleTrees;
    }

    @Override
    public List<SysRole> queryList(String filterParam) {
        MPJLambdaWrapper<SysRole> queryWrapper = this.buildLambdaWrapper(filterParam, "");
        List roleList = this.list((Wrapper)queryWrapper);
        SaasEntityUtil.wrapper(roleList);
        return roleList;
    }

    @Override
    public MPJLambdaWrapper<SysRole> buildLambdaWrapper(String filterParam, String sortParam) {
        MPJLambdaWrapper queryWrapper = ISaasEntityService.super.buildLambdaWrapper(filterParam, sortParam);
        queryWrapper.orderByAsc((Object)"f_sort");
        return queryWrapper;
    }

    @Override
    public IPage<SysRole> queryPage(String filterParam, int page, int size) throws Exception {
        MPJLambdaWrapper<SysRole> queryWrapper = this.buildLambdaWrapper(filterParam, "");
        Page pages = new Page((long)page, (long)size);
        pages = (Page)this.page((IPage)pages, (Wrapper)queryWrapper);
        SaasEntityUtil.wrapper(pages.getRecords());
        return pages;
    }

    @Override
    public SysRole findOne(String id, String filterParam) throws Exception {
        SysRole role = (SysRole)this.getById((Serializable)((Object)id));
        if (filterParam == null) {
            filterParam = "";
        }
        if (role.getType() == 0) {
            MPJLambdaWrapper<SysRole> queryWrapper = this.buildLambdaWrapper(filterParam, "");
            queryWrapper.eq(SysRole::getPid, (Object)id);
            queryWrapper.distinct();
            List childRoles = ((SysRoleMapper)this.getBaseMapper()).selectJoinList(SysRole.class, (MPJBaseJoin)queryWrapper);
            if (role != null) {
                role.setChildren(childRoles.stream().distinct().collect(Collectors.toList()));
            }
        }
        SaasEntityUtil.wrapper(Collections.singletonList(role));
        return role;
    }

    @Override
    public void batchDelete(String ids) throws Exception {
        if (StrUtil.isBlank((CharSequence)ids)) {
            return;
        }
        List<String> idList = Arrays.asList(ids.split(","));
        for (String id : idList) {
            this.deleteById(id);
        }
    }

    @Override
    public List<SysUser> queryRelUsers(String roleId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserRole::getRoleid, (Object)roleId);
        List userRoles = this.sysUserRoleService.list((Wrapper)wrapper);
        if (userRoles == null || userRoles.size() == 0) {
            return null;
        }
        List<SysUser> users = this.userService.query(userRoles.stream().map(f -> f.getUserid()).collect(Collectors.toList()));
        SysUserUtil.wrapperUsers(users);
        return users;
    }

    @Override
    public IPage<SysUser> queryPageUsers(String roleId, String noRoleId, String filterParam, String sortParam, int page, int size) throws Exception {
        List<String> userIds;
        if (StrUtil.isBlank((CharSequence)sortParam)) {
            sortParam = "SORT_createtime_DESC";
        }
        if (StrUtil.isBlank((CharSequence)filterParam)) {
            filterParam = "";
        }
        if (StrUtil.isNotBlank((CharSequence)filterParam)) {
            filterParam = filterParam + ";";
        }
        if (StrUtil.isNotBlank((CharSequence)roleId)) {
            userIds = this.sysUserRoleService.queryRoleUserIds(roleId);
            filterParam = userIds.size() > 0 ? filterParam + "Q_id_N_IN=" + StrUtil.join((CharSequence)",", userIds) + ";" : filterParam + "Q_id_N_IN=" + StrUtil.join((CharSequence)",", (Object[])new Object[]{-100}) + ";";
        }
        if (StrUtil.isNotBlank((CharSequence)noRoleId) && (userIds = this.sysUserRoleService.queryRoleUserIds(noRoleId)).size() > 0) {
            filterParam = filterParam + "Q_id_N_NOTIN=" + StrUtil.join((CharSequence)",", userIds) + ";";
        }
        IPage<SysUser> results = this.userService.queryPage(filterParam, page, size);
        SysUserUtil.wrapperUsers(results.getRecords());
        return results;
    }

    @Override
    public List<SysRole> queryUserRoles(String userId) {
        List<SysRole> roles = ((SysRoleMapper)this.baseMapper).queryUserRoles(userId);
        List<SysRole> total = this.queryList("");
        roles.removeIf(f -> !total.stream().anyMatch(g -> g.getId().equals(f.getId())));
        SaasEntityUtil.wrapper(roles);
        return roles;
    }

    @Override
    public void sortRoles(String id, String pid, int flag) {
        List<SysRole> roles = this.initSort(pid);
        int iCount = roles.size();
        if (iCount < 2) {
            return;
        }
        int index = roles.stream().map(i -> i.getId()).collect(Collectors.toList()).indexOf(id);
        if (index < 0) {
            return;
        }
        SysRole curRole = roles.get(index);
        List otherRoles = roles.stream().filter(item -> !item.getId().equals(id)).collect(Collectors.toList());
        switch (flag) {
            case 1: {
                int start = 2;
                curRole.setSort(1);
                for (SysRole role : otherRoles) {
                    role.setSort(start);
                    ++start;
                }
                otherRoles.add(curRole);
                this.updateBatchById(roles);
                break;
            }
            case 2: {
                if (index <= 0) break;
                SysRole changRole = roles.get(index - 1);
                int iSort = changRole.getSort();
                changRole.setSort(curRole.getSort());
                curRole.setSort(iSort);
                this.updateById(curRole);
                this.updateById(changRole);
                break;
            }
            case 3: {
                if (index >= iCount - 1) break;
                SysRole changRole = roles.get(index + 1);
                int iSort = changRole.getSort();
                changRole.setSort(curRole.getSort());
                curRole.setSort(iSort);
                this.updateById(curRole);
                this.updateById(changRole);
                break;
            }
            case 4: {
                int start2 = 1;
                for (SysRole role : otherRoles) {
                    role.setSort(start2);
                    ++start2;
                }
                curRole.setSort(start2);
                otherRoles.add(curRole);
                this.updateBatchById(roles);
                break;
            }
        }
    }

    @Override
    public List<SysRole> initSort(String pid) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        if (pid == null) {
            queryWrapper.isNull(SysRole::getPid);
        } else {
            queryWrapper.eq(SysRole::getPid, (Object)pid);
        }
        queryWrapper.orderByAsc(SysRole::getSort);
        List roles = this.list((Wrapper)queryWrapper);
        int iCount = roles.size();
        if (iCount < 2) {
            return roles;
        }
        LambdaQueryWrapper queryWrapper2 = Wrappers.lambdaQuery();
        if (pid == null) {
            queryWrapper2.isNull(SysRole::getPid);
        } else {
            queryWrapper2.eq(SysRole::getPid, (Object)pid);
        }
        queryWrapper2.groupBy(SysRole::getSort);
        queryWrapper2.select(new SFunction[]{SysRole::getSort});
        List list2 = this.listMaps((Wrapper)queryWrapper2);
        int iCount2 = list2.size();
        if (iCount > iCount2) {
            for (int i = 0; i < roles.size(); ++i) {
                SysRole role = (SysRole)roles.get(i);
                role.setSort(i + 1);
            }
            this.updateBatchById(roles);
        }
        SaasEntityUtil.wrapper(roles);
        return roles;
    }

    @Override
    public void dragRoleNode(String id, String refId, String type) throws Exception {
        SysRole role = (SysRole)this.getById((Serializable)((Object)id));
        SysRole refRole = (SysRole)this.getById((Serializable)((Object)refId));
        String pid = refRole.getPid();
        int sort = refRole.getSort();
        role.setLevel(refRole.getLevel());
        if (type.equals("inner")) {
            pid = refRole.getId();
            role.setLevel(refRole.getLevel() + 1);
        }
        role.setPid(pid);
        role.setSort(sort);
        this.buildAllName(role);
        this.saveOrUpdate(role);
        this.initSort(pid);
        int sortType = 2;
        if (type.equals("after")) {
            sortType = 3;
        } else if (type.equals("inner")) {
            sortType = 4;
        }
        this.sortRoles(id, pid, sortType);
    }

    @Override
    public int queryCount(String filterParam) throws Exception {
        MPJLambdaWrapper queryWrapper = ISaasEntityService.super.buildLambdaWrapper(filterParam, "");
        int count = this.count((Wrapper)queryWrapper);
        return count;
    }

    @Override
    public void bindUsers(String roleId, String userIds) {
        if (StrUtil.isBlank((CharSequence)userIds) || StrUtil.isBlank((CharSequence)roleId)) {
            return;
        }
        List<String> userIdList = Arrays.asList(userIds.split(","));
        this.sysUserRoleService.bindUsers(roleId, userIdList);
    }

    @Override
    public void removeBindUsers(String roleId, String userIds) {
        if (StrUtil.isBlank((CharSequence)userIds) || StrUtil.isBlank((CharSequence)roleId)) {
            return;
        }
        List<String> userIdList = Arrays.asList(userIds.split(","));
        this.sysUserRoleService.removeBindUsers(roleId, userIdList);
    }

    private void deleteById(String id) throws Exception {
        SysRole role = (SysRole)this.getById((Serializable)((Object)id));
        if (role.getType() == 1) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysUserRole::getRoleid, (Object)id);
            int iCount = this.sysUserRoleService.count((Wrapper)wrapper);
            if (iCount > 0) {
                throw new Exception("\u8be5\u89d2\u8272\u4e0b\u5df2\u5173\u8054\u7528\u6237\uff0c\u4e0d\u80fd\u5220\u9664!");
            }
            LambdaQueryWrapper wrapper2 = Wrappers.lambdaQuery();
            wrapper2.eq(SysRoleSystem::getRoleid, (Object)id);
            this.sysRoleSystemMapper.delete((Wrapper)wrapper2);
        } else {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysRole::getPid, (Object)id);
            List subRoles = this.list((Wrapper)wrapper);
            for (SysRole subRole : subRoles) {
                this.deleteById(subRole.getId());
            }
        }
        this.removeById((Serializable)((Object)id));
    }

    private List<SysRole> constructTree(List<SysRole> list) {
        int minLevel = 99;
        HashMap mapParam = new HashMap();
        for (SysRole role : list) {
            String key = role.getPid();
            if (!StringUtils.isEmpty((String)key) && !key.equals("0")) {
                if (mapParam.containsKey(key)) {
                    ((List)mapParam.get(key)).add(role);
                } else {
                    ArrayList<SysRole> childList = new ArrayList<SysRole>();
                    childList.add(role);
                    mapParam.put(key, childList);
                }
            }
            if (role.getLevel() >= minLevel) continue;
            minLevel = role.getLevel();
        }
        ArrayList<SysRole> results = new ArrayList<SysRole>();
        for (SysRole role : list) {
            String key = role.getId();
            if (StringUtils.isNotBlank((CharSequence)key) && mapParam.containsKey(key)) {
                role.setChildren((List)mapParam.get(key));
            }
            if (role.getLevel() != minLevel) continue;
            results.add(role);
        }
        return results;
    }

    private void buildChildALlName(SysRole role) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        List roles = this.list((Wrapper)wrapper);
        for (SysRole subRole : roles) {
            this.buildAllName(subRole);
        }
    }

    private void buildAllName(SysRole role) {
        role.setAllname(role.getName());
    }
}

