package com.geoway.jckj.biz.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author by wangqiang
 * @date 2024/12/27.
 */
@Data
public class SysMenuDTO {

    @ApiModelProperty(value = "id")
    private String id;

    /**
     * 名称
     */
    @NotBlank(message = "名称不能为空")
    @ApiModelProperty(value = "名称")
    private String name;

    /**
     * 菜单关键字
     */
    @NotBlank(message = "菜单关键字不能为空")
    @ApiModelProperty(value = "菜单关键字")
    private String key;

    /**
     * 上级id
     */
    @NotBlank(message = "上级id不能为空")
    @ApiModelProperty(value = "上级id")
    private String pid;

    /**
     * 排序
     */
    @ApiModelProperty(value = "排序")
    private Integer sort;

    /**
     * 对应系统id
     */
    @NotBlank(message = "对应系统id不能为空")
    @ApiModelProperty(value = "对应系统id")
    private String systemId;

    @NotNull(message = "菜单分组不能为空")
    @ApiModelProperty(value = "菜单分组(1.普通菜单 2.个人中心菜单）")
    private Integer group;

    /**
     * 菜单类型（1.原始菜单 2.挂接菜单）
     */
    @NotNull(message = "菜单类型不能为空")
    @ApiModelProperty(value = "菜单类型（1.原始菜单 2.挂接菜单）")
    private Integer menuType;

    /**
     * 关联菜单id
     */
    @ApiModelProperty(value = "关联菜单id")
    private String relMenuId;

    /**
     * 打开方式（1.单页面 2.iframe 3.x新页面）
     */
//    @NotNull(message = "打开方式不能为空")
    @ApiModelProperty(value = "打开方式（1.单页面 2.iframe 3.x新页面）")
    private Integer openMode;

    /**
     * 是否缓存
     */
    @ApiModelProperty(value = "是否缓存")
    private Integer isCache;

    /**
     * 是否免登录
     */
    @ApiModelProperty(value = "是否缓存")
    private Integer nologin;

    /**
     * 菜单icon
     */
    @ApiModelProperty(value = "菜单icon")
    private String icon;

    /**
     * 菜单激活icon
     */
    @ApiModelProperty(value = "菜单激活icon")
    private String activeIcon;

    /**
     * 路径id
     */
    @ApiModelProperty(value = "路径id")
    private String pathId;

    /**
     * 菜单路径
     */
    @ApiModelProperty(value = "菜单路径")
    private String path;

    /**
     * 路径类型（1.相对路径 2.绝对路径）
     */
    @ApiModelProperty(value = "路径类型（1.相对路径 2.绝对路径）")
    private Integer pathType;
}
