package com.geoway.jckj.biz.dto.uis;

import lombok.Data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author 阿力
 * @desc UIS行政区实体
 */
@Data
public class RegionDTO {

    /**
     * 行政区id
     */
    private String id;
    /**
     * 行政区名称
     */
    private String name;

    /**
     * 行政区代码
     */
    private String code;

    /**
     * 上级行政区
     */
    private String pid;

    /**
     * 状态
     */
    private Boolean status;

    /**
     * 顺序
     */
    private Integer order;

    /**
     * 级别
     */
    private Integer level;

    /**
     * 类型
     */
    private String type;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * x边至
     */
    private Double xmin;

    /**
     * x边至
     */
    private Double xmax;

    /**
     * y边至
     */
    private Double ymin;

    /**
     * y边至
     */
    private Double ymax;

//    private Geometry shape;

    /**
     * 中心点x
     */
    private Double centerX;

    /**
     * 中心点y
     */
    private Double centerY;


    /**
     * 上级id
     */
    private String _parentId;

    /**
     * 状态
     */
    private String state = "closed";

    /**
     * 别名
     */
    private String text;

    /**
     * 行政区类型
     */
    private String regionTypeCode;

    /**
     * 子行政区
     */
    private List<RegionDTO> children = new ArrayList<RegionDTO>();


    /**
     * 是否莫急行政区
     */
    private boolean leaf = false;

    /**
     * 用户数量
     */
    private int userCount;

    /**
     * 在线用户数量
     */
    private int userCountOnline;


}
