package com.geoway.jckj.biz.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 
 * @TableName sys_app_build
 */
@TableName(value ="sys_app_build")
@Data
public class SysAppBuild implements Serializable {
    /**
     * id
     */
    @TableId(value = "f_id",type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 应用名字
     */
    @TableField(value = "f_name")
    private String name;

    /**
     * 手机号
     */
    @TableField(value = "f_tel")
    private String tel;

    /**
     * 审核状态：0未审核，1通过，2不通过
     */
    @TableField(value = "f_audit_state")
    private String auditState;

    /**
     * 审核意见
     */
    @TableField(value = "f_audit_opinion")
    private String auditOpinion;

    /**
     * 审核人
     */
    @TableField(value = "f_audit_user")
    private String auditUser;

    /**
     * 审核时间
     */
    @TableField(value = "f_audit_time")
    private Date auditTime;

    /**
     * 注册时间
     */
    @TableField(value = "f_createtime")
    private Date createtime;

    /**
     * 组织id
     */
    @TableField(value = "f_organization")
    private String organization;

    /**
     * 申请人
     */
    @TableField(value = "f_apply_user")
    private String applyUser;

    /**
     * 申请人id
     */
    @TableField(value = "f_apply_user_id")
    private String applyUserId;

    /**
     * 用途
     */
    @TableField(value = "f_purpose")
    private String purpose;

    /**
     * 0未搭建，1已搭建
     */
    @TableField(value = "f_build_status")
    private Integer buildStatus;

    /**
     * 应用地址
     */
    @TableField(value = "f_app_url")
    private String appUrl;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}