package com.geoway.jckj.biz.entity;

import com.baomidou.mybatisplus.annotation.*;

import java.io.Serializable;
import java.util.Date;
import java.util.List;


import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 租户表
 * @TableName sys_tenant
 */
@TableName(value ="sys_tenant")
@Data
public class SysTenant implements Serializable {
    /**
     * 
     */
    @TableId(value = "f_id", type = IdType.ASSIGN_UUID)
    private String id;

    /**
     * 租户名称
     */
    @TableField(value = "f_name")
    private String name;

    /**
     * 关键字
     */
    @TableField(value = "f_key",updateStrategy= FieldStrategy.NEVER)
    private String key;

    /**
     * 创建时间
     */
    @TableField(value = "f_createtime", fill = FieldFill.INSERT)
    private Date createtime;

    /**
     * 备注
     */
    @TableField(value = "f_bz")
    private String bz;

    /**
     * 备注
     */
    @TableField(value = "f_roleid")
    private String defaultRoleId;


    @TableField(exist = false)
    @ApiModelProperty(hidden=true)
    List<SysSystem> systems;

    @TableField(exist = false)
    @ApiModelProperty(hidden=true)
    List<SysUser> users;

    @TableField(exist = false)
    @ApiModelProperty(hidden=true)
    List<SysRegion> regions;
    @TableField(exist = false)
    @ApiModelProperty(hidden=true)
    List<SysOrganization> organizations;
    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}