package com.geoway.jckj.biz.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import lombok.Data;

/**
 * 租户表
 * @TableName sys_tenant_system
 */
@TableName(value ="sys_tenant_system")
@Data
public class SysTenantSystem implements Serializable {
    /**
     * 
     */
    @TableId(value = "f_id", type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 租户id
     */
    @TableField(value = "f_tenantid")
    private String tenantid;

    /**
     * 系统id
     */
    @TableField(value = "f_systemid")
    private String systemid;

    /**
     * 在租户空间下的系统名称
     */
    @TableField(value = "f_name")
    private String name;


    /**
     * 在租户空间下的系统图标
     */
    @TableField(value = "f_icon")
    private String icon;


    /**
     * 租户空间下的主题id
     */
    @TableField(value = "f_themeid")
    private String themeid;

    /**
     * 租户空间下的样式
     */
    @TableField(value = "f_style")
    private String style;

    /**
     *租户空间下的logo id
     */
    @TableField(value = "f_logid")
    private String logoid;


    /**
     *租户空间下的背景 id
     */
    @TableField(value = "f_bgid")
    private String bgid;

    @TableField(value = "f_params")
    private String params;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

}