package com.geoway.jckj.biz.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 主题样式
 * @author: daidd
 * @Date: 2025/1/7
 */
@Data
@NoArgsConstructor
@TableName(value = "sys_theme",autoResultMap = true)
public class SysTheme implements Serializable {

    @TableId(value = "f_id", type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 主题名称
     */
    @TableField(value = "f_name")
    private String name;

    /**
     * 主题关键字
     */
    @TableField(value = "f_key")
    private String key;

    /**
     * 主题内容
     */
    @TableField(value = "f_content")
    private String content;

    /**
     * 背景图片（base64方式）
     */
    @TableField(value = "f_bg")
    private String bg;

    /**
     * 缩略图
     */
    @TableField(value = "f_snapshot")
    private String snapshot;

    @TableField(value = "f_sort")
    private Integer sort;
}
