package com.geoway.jckj.biz.service.dev.base.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.Pair;
import com.geoway.jckj.biz.service.dev.base.ISmsService;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @author 连世忠
 * @ClassName SmsServiceImpl
 * @Description TODO
 * @date 2025/6/11 9:47
 * @Version 1.0
 */
@Service
public class SmsServiceImpl  implements ISmsService {
    @Value("${SMS.url}")
    private String smsURL;
    private final Logger logger = LoggerFactory.getLogger(getClass());
    @Override
    public Pair<Boolean, String> sendMessage(String phones, String customId, String content) {
        try {
            Map<String, Object> map = new HashMap<>(8);
            map.put("phones", phones);
            map.put("customId", customId);
            map.put("content", content);
            logger.info("发送的手机号:{},发送的内容:{}", phones, content);
            String post = HttpUtil.post(smsURL + "/sms", map);
            JSONObject jsonObject = JSONObject.parseObject(post);
            boolean successd = jsonObject != null && "ok".equalsIgnoreCase(jsonObject.getString("status"));
            if (successd) {
                return new Pair<>(true, "");
            } else {
                return new Pair<>(false, jsonObject != null && StrUtil.isNotBlank(jsonObject.getString("description"))
                        ? jsonObject.getString("description") : "获取验证码失败");
            }
        }catch (Exception exception){
            throw new ServiceException("获取验证码失败",exception);
        }
    }
}
