package com.geoway.jckj.biz.service.dev.unity.impl;

import cn.hutool.captcha.AbstractCaptcha;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.jckj.base.constants.CommonConstants;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.biz.dto.CaptchaIMGDTO;
import com.geoway.jckj.biz.dto.CaptchaTextDTO;
import com.geoway.jckj.biz.service.dev.base.ILoginService;
import com.geoway.jckj.biz.service.dev.unity.IUnityLoginService;
import com.geoway.jckj.biz.service.login.ICaptchaService;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.HttpServletUtil;
import com.geoway.sso.client.util.SessionUtils;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.UUID;

/**
 * @author 连世忠
 * @ClassName UnityLoginServiceImpl
 * @Description 统一登入
 * @date 2024/10/17 10:28
 * @Version 1.0
 */
@Service
@Slf4j
public class UnityLoginServiceImpl extends  UnityBaseImpl<ILoginService> implements IUnityLoginService {

    @Autowired
    private ICaptchaService commonService;
    @Autowired
    private DefaultKaptcha defaultKaptcha;
    @Override
    public CaptchaTextDTO createCaptchaText(HttpServletRequest req) {
        String capText = defaultKaptcha.createText();
        UUID uid = UUID.randomUUID();
        String uuid = uid.toString();
        commonService.storeCaptcha(uuid, capText);
        CaptchaTextDTO captchaDTO=new CaptchaTextDTO();
        captchaDTO.setText(capText);
        captchaDTO.setUid(uuid);
        return captchaDTO;
    }

    @Override
    public CaptchaIMGDTO createCaptchaIMG(HttpServletRequest req, HttpServletResponse resp) {
        try {
            String w = req.getParameter("w");
            String h = req.getParameter("h");
            AbstractCaptcha captcha = commonService.createImageCaptcha(w, h);
            UUID uid = UUID.randomUUID();
            String uuid = uid.toString();
            commonService.storeCaptcha(uuid,captcha.getCode());
            CaptchaIMGDTO captchaIMGDTO =new CaptchaIMGDTO();
            captchaIMGDTO.setUid(uuid);
            captchaIMGDTO.setBase64(captcha.getImageBase64Data());
            return captchaIMGDTO;
        }catch (Exception exception){
            throw new RuntimeException(exception);
        }
    }

    @Override
    public Result<SsoUser> loginByOne(String processId, String token, String authCode, HttpServletRequest req) {
        List<ILoginService> loginServices=getServices();
        Result<SsoUser> result=null;
        for(ILoginService loginService:loginServices){
            try{
                result = loginService.loginByOne(processId, token,authCode,req);
                if (result != null && result.getCode() == CommonConstants.STATUS_RESETPASSWORD) {
                    return result;
                }
                if (result != null && result.isSuccess()) {
                    result.getData().setLoginTime(DateUtil.now());
                    result.getData().setMachineName("Administrator");
                    result.getData().setIp(HttpServletUtil.getRequestClientIp(HttpServletUtil.getRequest()));
                    return result;
                } else {
                    log.error(String.format("登录方式[%s]报错：", loginService.getUserSystem()), result == null ? "" : result.getMessage());
                    // 当前若为最后一个实现类，抛出异常
                    if (loginServices.indexOf(loginService) == loginServices.size() - 1) {
                        throw new RuntimeException(result.getMessage());
                    }
                }
            }catch (Exception exception){
                log.error(String.format("登录方式[%s]报错：",loginService.getUserSystem()),exception);
                throw new ServiceException("登入失败："+exception.getMessage(),exception);
            }
        }
        return result;
    }

    @Override
    public Result<SsoUser> loginByCa(String caUserCert, String caOauthName, HttpServletRequest req) {
        List<ILoginService> loginServices=getServices();
        Result<SsoUser> result=null;
        for(ILoginService loginService:loginServices){
            try{
                result = loginService.loginByCa(caUserCert, caOauthName, req);
                if (result != null && result.getCode() == CommonConstants.STATUS_RESETPASSWORD) {
                    return result;
                }
                if (result != null && result.isSuccess()) {
                    result.getData().setLoginTime(DateUtil.now());
                    result.getData().setMachineName("Administrator");
                    result.getData().setIp(HttpServletUtil.getRequestClientIp(HttpServletUtil.getRequest()));
                    return result;
                } else {
                    log.error(String.format("登录方式[%s]报错：", loginService.getUserSystem()), result == null ? "" : result.getMessage());
                    // 当前若为最后一个实现类，抛出异常
                    if (loginServices.indexOf(loginService) == loginServices.size() - 1) {
                        throw new RuntimeException(result.getMessage());
                    }
                }
            }catch (Exception exception){
                log.error(String.format("登录方式[%s]报错：",loginService.getUserSystem()),exception);
                throw new ServiceException("登入失败："+exception.getMessage(),exception);
            }
        }
        return result;
    }

    @Override
    public Result<SsoUser> loginBySms(String tel, String uuid, String code, HttpServletRequest req) {
        List<ILoginService> loginServices=getServices();
        Result<SsoUser> result=null;
        for(ILoginService loginService:loginServices){
            try{
                result = loginService.loginBySms(tel, uuid, code, req);
                if (result != null && result.getCode() == CommonConstants.STATUS_RESETPASSWORD) {
                    return result;
                }
                if (result != null && result.isSuccess()) {
                    result.getData().setLoginTime(DateUtil.now());
                    result.getData().setMachineName("Administrator");
                    result.getData().setIp(HttpServletUtil.getRequestClientIp(HttpServletUtil.getRequest()));
                    return result;
                } else {
                    log.error(String.format("登录方式[%s]报错：", loginService.getUserSystem()), result == null ? "" : result.getMessage());
                    // 当前若为最后一个实现类，抛出异常
                    if (loginServices.indexOf(loginService) == loginServices.size() - 1) {
                        throw new RuntimeException(result.getMessage());
                    }
                }
            }catch (Exception exception){
                log.error(String.format("登录方式[%s]报错：",loginService.getUserSystem()),exception);
                throw new ServiceException("登入失败："+exception.getMessage(),exception);
            }
        }
        return result;
    }

    @Override
    public Result<SsoUser> login(String username, String password,String uuid, String code, HttpServletRequest req) {
        try {
            List<ILoginService> loginServices = getServices();
            Result<SsoUser> result = null;
            for (ILoginService loginService : loginServices) {
                try {
                    result = loginService.login(username, password, uuid, code, req);
                    if (result != null && result.getCode() == CommonConstants.STATUS_RESETPASSWORD) {
                        return result;
                    }
                    if (result != null && result.isSuccess()) {
                        result.getData().setLoginTime(DateUtil.now());
                        result.getData().setMachineName("Administrator");
                        result.getData().setIp(HttpServletUtil.getRequestClientIp(HttpServletUtil.getRequest()));
                        return result;
                    } else {
                        log.error(String.format("登录方式[%s]报错：", loginService.getUserSystem()), result == null ? "" : result.getMessage());
                        // 当前若为最后一个实现类，抛出异常
                        if (loginServices.indexOf(loginService) == loginServices.size() - 1) {
                            throw new RuntimeException(result.getMessage());
                        }
                    }
                } catch (Exception exception) {

                    log.error(String.format("登录方式[%s]报错：", loginService.getUserSystem()), exception);
                    throw new ServiceException("登入失败：" + exception.getMessage(), exception);
                }
            }
            return result;
        }finally {
            if(StrUtil.isNotBlank(uuid)) {
                commonService.removeCaptcha(uuid);
            }
        }
    }

    @Override
    public Result<SsoUser> login(String username, String password) {
        Result<SsoUser>  result = login(username,password,null,null,null);
        return result;
    }

    @Override
    public boolean loginOut(HttpServletRequest request, String access_token) {
        for(ILoginService loginService:getServices()) {
            loginService.loginOut(request,access_token);
        }
        SessionUtils.invalidate(request,access_token);
        return true;
    }

}
