package com.geoway.jckj.biz.service.dev.unity.impl;

import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.entity.SysUserOrganization;
import com.geoway.jckj.biz.service.dev.base.IUserOrganizationService;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserOrganizationService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author 连世忠
 * @ClassName UnityUserOrganizationServiceImpl
 * @Description TODO
 * @date 2025/4/30 16:43
 * @Version 1.0
 */
@Service
@Slf4j
public class UnityUserOrganizationServiceImpl extends  UnityBaseImpl<IUserOrganizationService> implements IUnityUserOrganizationService {
    @Override
    public void updateUserOrg(String userId, List<String> orgIds) {
        getService().updateUserOrg(userId,orgIds);
    }

    @Override
    public void updateOrgUsers(String orgId, List<String> userIds) {
        getService().updateOrgUsers(orgId,userIds);
    }

    @Override
    public void saveBatch(List<SysUserOrganization> userOrgs) {
        getService().saveBatch(userOrgs);
    }

    @Override
    public void saveOne(SysUserOrganization userOrg) {
        getService().saveOne(userOrg);
    }

    @Override
    public void removeByOrgUserId(String orgId, String userId) {
        getService().removeByOrgUserId(orgId,userId);
    }

    @Override
    public void removeByOrgUserIds(String orgId, List<String> userIds) {
        getService().removeByOrgUserIds(orgId,userIds);
    }

    @Override
    public List<String> queryOrgUserIds(String orgId) {
        return getService().queryOrgUserIds(orgId);
    }

    @Override
    public List<SysUserOrganization> queryByOrgId(String orgId) {
        return getService().queryByOrgId(orgId);
    }

    @Override
    public List<SysUserOrganization> queryList(String filterParam) {
        return getService().queryList(filterParam);
    }

    @Override
    public List<SysUser> queryUsersByOrgsIds(List<String> orgIds) {
        return getService().queryUsersByOrgsIds(orgIds);
    }
}
