package com.geoway.jckj.biz.service.login;

import cn.org.bjca.client.security.SecurityEngineDeal;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.Pair;
import com.geoway.jckj.base.support.StringUtils;
import com.geoway.jckj.biz.service.login.ICAService;
import org.springframework.stereotype.Service;

/**
 * @author 连世忠
 * @ClassName CAServiceImpl
 * @Description TODO
 * @date 2025/6/11 10:37
 * @Version 1.0
 */
@Service
public class CAServiceImpl implements ICAService {
    @Override
    public Pair<Boolean, String> validate(String caUserCert, String caOauthName) {
        try {
            SecurityEngineDeal sed = null;
            sed = SecurityEngineDeal.getInstance("SVSDefault");
            int retValue = sed.validateCert(caUserCert);
            if (retValue == 1) {
                String sfz = sed.getCertInfoByOid(caUserCert, "2.16.840.1.113732.2");
                return new Pair<>(StringUtils.isNotEmpty(sfz), StringUtils.isNotEmpty(sfz) ? sfz : "获取身份证失败，请联系管理员");
            } else if (retValue == 0) {
                return new Pair<>(false, "验证时，发生未知错误，请联系管理员");
            } else if (retValue == -1) {
                return new Pair<>(false, "登录证书的根不被信任，请联系管理员");
            } else if (retValue == -2) {
                return new Pair<>(false, "登录证书超过有效期，请联系管理员");
            } else if (retValue == -3) {
                return new Pair<>(false, "登录证书为作废证书，请联系管理员");
            } else if (retValue == -4) {
                return new Pair<>(false, "登录证书被临时冻结，请联系管理员");
            }
        } catch (Exception ex) {
            throw new ServiceException("验证时，发生错误，请联系管理员", ex);
        }
        return new Pair<>(false, "未通过证书验证，请联系管理员");
    }

}
