package com.geoway.jckj.biz.service.sys;

import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.jckj.biz.entity.SysUserRole;

import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_user_role】的数据库操作Service
* @createDate 2021-11-30 19:24:11
*/
public interface SysUserRoleService extends IService<SysUserRole> {

    /**
     * 更新用户关联角色
     * @param userId
     * @param roleIds
     */
     void updateUserRole(String userId, List<String> roleIds);

    /**
     * 更新角色关联用户
     * @param roleId
     * @param userIds
     */
     void updateRoleUsers(String roleId, List<String> userIds);



    /**
     *  根据角色id查询对应的用户id
     * @param roleId
     * @return
     */
    List<String> queryRoleUserIds(String roleId);


    /**
     * 绑定角色关联的用户
     * @param roleId
     * @param userIds
     */
    void bindUsers(String roleId,List<String> userIds);

    /**
     * 移除角色绑定的用户
     * @param roleId
     * @param userIds
     */
    void removeBindUsers(String roleId,List<String> userIds);



}
