package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.StringUtils;
import com.geoway.jckj.base.support.query.MPJQueryMapperUtil;
import com.geoway.jckj.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.jckj.biz.constants.TenantConstants;
import com.geoway.jckj.biz.entity.*;
import com.geoway.jckj.biz.mapper.SysRegionMapper;
import com.geoway.jckj.biz.service.ISaasEntityService;
import com.geoway.jckj.biz.service.sys.SysRegionService;

import com.geoway.jckj.biz.util.TenantUtil;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author daidongdong
 * @description 针对表【sys_region】的数据库操作Service实现
 * @createDate 2022-01-20 15:42:06
 */
@Service
public class SysRegionServiceImpl extends MPJBaseServiceImpl<SysRegionMapper, SysRegion>
        implements SysRegionService, ISaasEntityService<SysRegion> {

    //@Autowired
    //SysXzqRegionService sysXzqRegionService;


    private boolean exsits(SysRegion region){
        //判断名称是否重复
        if(StrUtil.isBlank(region.getPid())){
            region.setPid("-1");
            region.setPcode("-1");
        }
        LambdaQueryWrapper<SysRegion> wrapper = Wrappers.lambdaQuery();

        wrapper.eq(SysRegion::getPid, region.getPid());
        //有id就是更新
        if (StrUtil.isNotBlank(region.getId())) {
            wrapper.ne(SysRegion::getId, region.getId());
        }

        LambdaQueryWrapper<SysRegion>  codeWrapper=wrapper.clone().eq(SysRegion::getCode, region.getCode());
        int iCount = this.count(codeWrapper);
        if (iCount > 0) {
            throw new ServiceException("辖区编码已存在："+region.getCode());
        }
        LambdaQueryWrapper<SysRegion> nameWrapper=wrapper.clone().eq(SysRegion::getName, region.getName());

        iCount = this.count(nameWrapper);
        if (iCount > 0) {
            throw new ServiceException("辖区名称已存在:"+region.getName());
        }
        return false;
    }
    @Override
    public void saveOrUp(SysRegion region) throws Exception {
        if(exsits(region)){
            throw new ServiceException("辖区已存在："+region.getName());
        }
        LambdaQueryWrapper<SysRegion> wrapper = Wrappers.lambdaQuery();
        wrapper.clear();
        wrapper.eq(SysRegion::getId, region.getPid());
        wrapper.last(" limit 1 ");
        SysRegion pRegion = this.getOne(wrapper);
        region.setLevel(pRegion == null ? 1 : pRegion.getLevel() + 1);
        region.setPcode(pRegion == null ? "-1" : pRegion.getCode());
        if (StrUtil.isNotBlank(region.getId())) {
            //编辑模式下code变了，修改下级pcode
            SysRegion old = this.getById(region.getId());
            if(!region.getCode().equals(old.getCode())){
                LambdaUpdateWrapper<SysRegion> lambdaUpdateWrapper = new LambdaUpdateWrapper<>();
                lambdaUpdateWrapper.eq(SysRegion::getPid, old.getId()).set(SysRegion::getPcode, region.getCode());
                this.update(null, lambdaUpdateWrapper);
            }
        }else{
            Long id= IdWorker.getId();
            region.setId(id.toString());
            region.setIdpath(pRegion == null?region.getId():pRegion.getIdpath()+"->"+region.getId());
            wrapperEntity(region);
        }

        this.saveOrUpdate(region);
    }

    @Override
    public List<SysRegion> queryTree(String filterParam, String sortParam) throws Exception {

        List<SysRegion> regions = this.queryList(filterParam, sortParam);
        return constructTree(regions);
    }

    @Override
    public List<SysRegion> queryList(String filterParam, String sortParam) throws Exception {

        MPJLambdaWrapper queryWrapper = buildLambdaWrapper(filterParam,sortParam);
        List<SysRegion> regions = this.list(queryWrapper);
        return regions;
    }


    @Override
    public List<SysRegion> queryRegionListById(String regionId) {
        List<SysRegion> children = this.baseMapper.getRegionListById(regionId);
        Collections.reverse(children);
        return children;
    }

    @Override
    public List<SysRegion> queryAllParentRegionById(String regionCode) {
        List<SysRegion> result = this.baseMapper.getAllParentRegionById(regionCode);
        Collections.reverse(result);
        return result;
    }

    @Override
    public IPage<SysRegion> queryPage(String filterParam, int page, int size) throws Exception {

        MyBatisQueryMapperUtils<SysRegion> qmu = new MyBatisQueryMapperUtils<>();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysRegion.class);
        Page<SysRegion> pages = new Page<>(page, size);

        return this.page(pages, queryWrapper);
    }

    @Override
    public void batchDelete(String ids) {
        if (StrUtil.isBlank(ids)) {
            return;
        }
        List<String> idList = Arrays.asList(ids.split(","));
        for (String id : idList) {
            this.deleteTree(id);
        }
    }

    @Override
    public SysRegion findOne(String id, String filterParam) throws Exception {
        SysRegion region = this.getById(id);
        if (filterParam == null) {
            filterParam = "";
        }
        filterParam += ";pcode_EQ_" + region.getCode();
        List<SysRegion> childrens = this.queryList(filterParam, "SORT_code_ASC");
        region.setChildren(childrens);

        return region;
    }







    @Override
    public void excelOutput(OutputStream outputStream, String id) throws IOException {
        ExcelWriter excelWriter = null;
        try {
            List<SysRegion> list=baseMapper.getRegionListById(id);
            list=list.stream().sorted(Comparator.comparing(f->f.getCode())).collect(Collectors.toList());
            List<Map<String, Object>> excelObjects = new ArrayList<>();
            //行政区名称、行政区代码、行政区级别
            for (SysRegion sysXzqRegion : list) {
                Map<String, Object> excelObject = new LinkedHashMap<>();
                excelObject.put("行政区名称", sysXzqRegion.getName());
                excelObject.put("行政区代码", sysXzqRegion.getCode());
                excelObject.put("父级行政区代码", sysXzqRegion.getPcode());
                excelObjects.add(excelObject);
            }
            excelWriter = ExcelUtil.getWriter();
            excelWriter.write(excelObjects);
            excelWriter.flush(outputStream, true);

        } catch (Exception ex) {
            log.error(DateUtil.now() + " 辖区导出，Excel异常：" + ex.getMessage());
        } finally {
            if (excelWriter != null) {
                excelWriter.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }

    }

    @Override
    public List<SysRegion> queryUserRegions(String userId) {
        List<SysRegion> regions= this.baseMapper.queryUserRegions(userId);
        if(TenantUtil.isSuperTenant()){
            return regions;
        }
        List<String> tenantRegions=TenantUtil.getTenantRegionIds();
        return regions.stream().filter(f->tenantRegions.contains(f.getId())).collect(Collectors.toList());
    }

    @Override
    public void excelImport(InputStream stream) {
       try {

            ExcelReader excelReader = ExcelUtil.getReader(stream, 0);
            List<List<Object>> excelList = excelReader.read(1);
            List<SysRegion> sysRegionList = new ArrayList<>();
            //行政区名称、行政区代码、行政区级别
            for (List<Object> excelObject : excelList) {
                SysRegion sysRegion = new SysRegion();
                String name = excelObject.get(0).toString();
                String code = excelObject.get(1).toString();
                String pCode = excelObject.get(2).toString();
                //String level = excelObject.get(3).toString();

                sysRegion.setName(name);
                sysRegion.setCode(code);
                sysRegion.setId(UUID.randomUUID().toString());
                sysRegion.setPcode(StrUtil.isBlank(pCode)?"-1":pCode);
                SysRegion parRegion=sysRegionList.stream().filter(f->f.getCode().equals(pCode)).findAny().orElse(null);
                if(parRegion==null){
                    sysRegion.setLevel(1);
                    sysRegion.setPid("-1");
                    sysRegion.setPcode("-1");
                    if(exsits(sysRegion)){
                        throw new ServiceException("辖区已存在："+sysRegion.getName());
                    }
                }else{
                    sysRegion.setLevel(parRegion.getLevel()+1);
                    sysRegion.setPid(parRegion.getId());
                    sysRegion.setPcode(parRegion.getPcode());
                }
                //sysRegion.setPinyin(excelObject.get(3).toString());
                sysRegionList.add(sysRegion);
            }
            saveBatch(sysRegionList);
        } catch (Exception ex) {
            throw new ServiceException(ex.getMessage(),ex);
        }
    }


    private void deleteTree(String id) {
        List<SysRegion> children=baseMapper.getRegionListById(id);
        this.removeByIds(children.stream().map(f->f.getId()).collect(Collectors.toList()));
    }
    /**
     * 获取查询方法
     * @return
     */
    @Override
    public MPJLambdaWrapper<SysRegion> buildLambdaWrapper(String filterParam,String sortParam){
        try {
            MPJQueryMapperUtil<SysRegion> qmu = new MPJQueryMapperUtil<>();
            MPJLambdaWrapper<SysRegion> queryWrapper = qmu.queryMapper(filterParam,sortParam, SysRegion.class);
            if(getTenantId().equals(TenantConstants.AdminTenantId)){
                return queryWrapper;
            }
            SysTenant sysTenant=getTenant();
            List<SysRegion> sysRegions=new ArrayList<>();

            for(SysRegion region:sysTenant.getRegions()){
                sysRegions.addAll(this.getBaseMapper().getRegionListById(region.getId()));
            }
            if(sysRegions.size()>0){
                queryWrapper.in(SysRegion::getId, sysRegions.stream().map(f->f.getId()).collect(Collectors.toList()));
            }else{
                queryWrapper.eq(SysRegion::getLevel,-100);
            }

            return queryWrapper;
        }catch (Exception exception){
            throw new ServiceException(exception);
        }
    }
    /**
     * 递归查询树
     *
     * @param list
     * @return
     */
    private List<SysRegion> constructTree(List<SysRegion> list) {
        int minLevel = 9;
        Map<String, List<SysRegion>> mapParam = new HashMap<>();
        for (SysRegion region : list) {
            String key = region.getPid();
            if (!StringUtils.isEmpty(key) && !key.equals("-1")) {
                if (mapParam.containsKey(key)) {
                    mapParam.get(key).add(region);
                } else {
                    List<SysRegion> childList = new ArrayList<>();
                    childList.add(region);
                    mapParam.put(key, childList);
                }
            }

            if (region.getLevel() < minLevel) {
                minLevel = region.getLevel();
            }
        }
        List<SysRegion> results = new ArrayList<>();
        for (SysRegion region : list) {
            String key = region.getId();
            if (StringUtils.isNotBlank(key) && mapParam.containsKey(key)) {
                region.setChildren(mapParam.get(key));
            }
            if (region.getLevel() == minLevel) {
                results.add(region);
            }
        }

        return results;
    }

}




