package com.geoway.jckj.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.base.support.StringUtils;
import com.geoway.jckj.biz.entity.SysRegion;
import com.geoway.jckj.biz.entity.SysTenantMenu;
import com.geoway.jckj.biz.entity.SysTenantRegion;
import com.geoway.jckj.biz.mapper.SysTenantMenuMapper;
import com.geoway.jckj.biz.mapper.SysTenantRegionMapper;
import com.geoway.jckj.biz.service.sys.SysRegionService;
import com.geoway.jckj.biz.service.sys.SysTenantMenuService;
import com.geoway.jckj.biz.service.sys.SysTenantRegionService;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_tenant_menu(租户表)】的数据库操作Service实现
* @createDate 2025-01-09 17:52:35
*/
@Service
public class SysTenantRegionServiceImpl extends ServiceImpl<SysTenantRegionMapper, SysTenantRegion>
    implements SysTenantRegionService {
    @Autowired
    SysRegionService sysRegionService;
    @Override
    public List<SysRegion> queryBindRegions(String tenantId) {
        MPJLambdaWrapper<SysRegion> queryWrapper = MPJWrappers.lambdaJoin();
        queryWrapper.leftJoin(SysTenantRegion.class,SysTenantRegion::getRegionid,SysRegion::getId);
        queryWrapper.eq(SysTenantRegion::getTenantid, tenantId);
        return sysRegionService.list(queryWrapper);
    }

    @Override
    public void bindRegions(String tenantId, List<String> regionIds) {
        LambdaQueryWrapper<SysTenantRegion> menuWrapper = Wrappers.lambdaQuery();
        menuWrapper.eq(SysTenantRegion::getTenantid,tenantId);
        this.remove(menuWrapper);
        List<SysTenantRegion> regions=new ArrayList<>();
        for(String regionId:regionIds){
            SysTenantRegion sysTenantRegion=new SysTenantRegion();
            sysTenantRegion.setRegionid(regionId);
            sysTenantRegion.setTenantid(tenantId);
            regions.add(sysTenantRegion);
        }
        this.saveBatch(regions);
    }

    @Override
    public void bindRegions(String tenantId, String regionIds) {
        if(StringUtils.isEmpty(regionIds)){
            regionIds="";
        }
        String[] regionIdArr = regionIds.split(",");
        bindRegions(tenantId,Arrays.asList(regionIdArr));
    }
}




