package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.biz.entity.SysTenant;
import com.geoway.jckj.biz.entity.SysTenantMenu;
import com.geoway.jckj.biz.entity.SysTenantSubFunction;
import com.geoway.jckj.biz.mapper.SysTenantMapper;
import com.geoway.jckj.biz.mapper.SysTenantSubfunctionMapper;
import com.geoway.jckj.biz.service.sys.SysRoleSubFunctionService;
import com.geoway.jckj.biz.service.sys.SysRoleSystemService;
import com.geoway.jckj.biz.service.sys.SysTenantSubFunctionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
* @author daidongdong
* @description 针对表【sys_tenant_menu(租户表)】的数据库操作Service实现
* @createDate 2025-01-09 17:52:35
*/
@Service
public class SysTenantSubFunctionServiceImpl extends ServiceImpl<SysTenantSubfunctionMapper, SysTenantSubFunction>
    implements SysTenantSubFunctionService {

    @Autowired
    private SysTenantMapper sysTenantMapper;
    @Autowired
    private SysRoleMenuServiceImpl sysRoleMenuServiceImpl;
    @Autowired
    SysRoleSystemService sysRoleSystemService;
    @Override
    public void bindSubFunctions(String tenantId, String menuId, String subFunctionIds) {
        List<String> idArr = Arrays.asList(subFunctionIds.split(","));
        LambdaQueryWrapper<SysTenantSubFunction> menuWrapper = Wrappers.lambdaQuery();
        menuWrapper.eq(SysTenantSubFunction::getTenantid,tenantId);
        menuWrapper.eq(SysTenantSubFunction::getMenuid,menuId);
        SysTenant sysTenant=sysTenantMapper.selectById(tenantId);
        if(StrUtil.isNotBlank(sysTenant.getDefaultRoleId())){
            sysRoleMenuServiceImpl.saveRoleSubFunctions(sysTenant.getDefaultRoleId(),menuId,
                    idArr);
        }
        this.remove(menuWrapper);
        List<SysTenantSubFunction> subFunctions=new ArrayList<>();
        for(String subFunctionId:idArr){
            SysTenantSubFunction subFunction=new SysTenantSubFunction();
            subFunction.setMenuid(menuId);
            subFunction.setTenantid(tenantId);
            subFunction.setSubfunctionid(subFunctionId);
            subFunctions.add(subFunction);
        }
        this.saveBatch(subFunctions);
    }
    @Override
    public List<SysTenantSubFunction> queryBindSubFunctions(String tenantId, String menuId) {
        LambdaQueryWrapper<SysTenantSubFunction> menuWrapper = Wrappers.lambdaQuery();
        menuWrapper.eq(SysTenantSubFunction::getTenantid,tenantId);
        menuWrapper.eq(SysTenantSubFunction::getMenuid,menuId);
        List<SysTenantSubFunction> menus=this.list(menuWrapper);
        return menus;
    }
}




