package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.biz.entity.*;
import com.geoway.jckj.biz.mapper.SysSystemMapper;
import com.geoway.jckj.biz.mapper.SysTenantMapper;
import com.geoway.jckj.biz.service.sys.*;
import com.geoway.jckj.biz.mapper.SysTenantSystemMapper;
import com.geoway.jckj.biz.util.BaseEntityUtil;
import com.geoway.jckj.biz.util.SaasEntityUtil;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_tenant_system(租户表)】的数据库操作Service实现
* @createDate 2025-01-09 17:52:35
*/
@Service
public class SysTenantSystemServiceImpl extends ServiceImpl<SysTenantSystemMapper, SysTenantSystem>
    implements SysTenantSystemService{
    @Autowired
    SysSystemMapper sysSystemMapper;
    @Autowired
    SysTenantMenuService sysTenantMenuService;
    @Autowired
    SysTenantSpaceService sysTenantSpaceService;
    @Autowired
    SysRoleSystemService sysRoleSystemService;
    @Autowired
    SysTenantMapper sysTenantMapper;
    @Autowired
    SysRoleMenuService sysRoleMenuService;


    @Override
    public void bindSystems(String tenantId, String systemIds) {
        this.removeBindSystems(tenantId,systemIds);
        String[] systemIdArr = systemIds.split(",");
        SysTenantSystem  sysTenantSystem= null;
        List<SysTenantSystem> sysTenantSystems = new ArrayList<>();
        List<SysSystem> sysSystems=sysSystemMapper.selectBatchIds(Arrays.asList(systemIdArr));
        for(SysSystem sysSystem:sysSystems){
            sysTenantSystem = new SysTenantSystem();
            BeanUtil.copyProperties(sysSystem,sysTenantSystem,"id");
            sysTenantSystem.setSystemid(sysSystem.getId());
            sysTenantSystem.setTenantid(tenantId);
            sysTenantSystems.add(sysTenantSystem);
        }
        if(sysTenantSystems.size() > 0){
            this.saveBatch(sysTenantSystems);
        }
        SysTenant sysTenant=sysTenantMapper.selectById(tenantId);
        if(StrUtil.isNotBlank(sysTenant.getDefaultRoleId())) {
            sysRoleSystemService.saveRoleSystems(sysTenant.getDefaultRoleId(),Arrays.asList(systemIdArr),false);
        }
    }




    @Override
    public void removeBindSystems(String tenantId, String systemIds) {
        if(StrUtil.isBlank(tenantId) || StrUtil.isBlank(systemIds) ){
            return;
        }

        List<String> systemIdList = Arrays.asList(systemIds.split(","));
        LambdaQueryWrapper<SysTenantSystem> clearWrapper = Wrappers.lambdaQuery();
        clearWrapper.eq(SysTenantSystem::getTenantid,tenantId);
        clearWrapper.in(SysTenantSystem::getSystemid,systemIdList);
        this.remove(clearWrapper);


        LambdaQueryWrapper<SysTenantMenu> menuWrapper = Wrappers.lambdaQuery();
        menuWrapper.eq(SysTenantMenu::getTenantid,tenantId);
        menuWrapper.in(SysTenantMenu::getSystemid,systemIdList);
        sysTenantMenuService.remove(menuWrapper);
        SysTenant sysTenant=sysTenantMapper.selectById(tenantId);
        if(StrUtil.isNotBlank(sysTenant.getDefaultRoleId())) {
            sysRoleSystemService.removeRoleSystem(sysTenant.getDefaultRoleId(), systemIdList);
        }

    }

    @Override
    public List<SysSystem> queryBindSystems(String tenantId) {
        MPJLambdaWrapper<SysTenantSystem> queryWrapper = MPJWrappers.lambdaJoin();
        queryWrapper.eq(SysTenantSystem::getTenantid,tenantId);
        List<SysTenantSystem> sysTenantSystems=this.list(queryWrapper);
        if(sysTenantSystems.size()==0){
            return new ArrayList<>();
        }
        List<SysSystem> systems=new ArrayList<>();
        for(SysTenantSystem sysTenantSystem:sysTenantSystems){
            SysSystem sysSystem=sysSystemMapper.selectById(sysTenantSystem.getSystemid());
            if(sysSystem==null){
                continue;
            }
            String dispalyName=sysSystem.getName();
            if(!sysSystem.getName().equals(sysTenantSystem.getName())){
                dispalyName=String.format("%s(%s)",sysTenantSystem.getName(),sysSystem.getName());
            }

            BeanUtil.copyProperties(sysTenantSystem,sysSystem,"id","tenantid");
            systems.add(sysSystem);
            sysSystem.setDisplayName(dispalyName);
        }
        SaasEntityUtil.wrapper(systems);
        systems.forEach(f->f.setSpaceStatus(sysTenantSpaceService.checkSpaceStatus(tenantId,f.getId()).getValue()));
        return systems;
    }

    @Override
    public void saveSystem(String tenantId, SysSystem sysSystem) {
        MPJLambdaWrapper<SysTenantSystem> queryWrapper = MPJWrappers.lambdaJoin();
        queryWrapper.eq(SysTenantSystem::getTenantid,tenantId);
        queryWrapper.eq(SysTenantSystem::getSystemid,sysSystem.getId());
        SysTenantSystem sysTenantSystems=this.getOne(queryWrapper,true);
        if(sysTenantSystems==null){
            throw new ServiceException("系统:"+sysSystem.getName()+",没有授权给该租户，无法进行编辑");
        }
        BeanUtil.copyProperties(sysSystem,sysTenantSystems,"id","tenantid");
        this.saveOrUpdate(sysTenantSystems);

    }
}




