/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.server;

import com.geoway.jckj.biz.service.oauth2.IOauth2Service;
import com.geoway.sso.client.enums.GrantTypeEnum;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.service.IOauth2Utils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnExpression(value="#{T(com.geoway.sso.client.constant.SystemConstant).IS_SERVER}")
public class ServerOauth2UtilsImpl
implements IOauth2Utils {
    @Autowired
    private IOauth2Service oauth2Service;

    public Result<RpcAccessToken> getAccessToken(String serverUrl, String appId, String appSecret, String username, String password) {
        RpcAccessToken rpcAccessToken = this.oauth2Service.getAccessToken(GrantTypeEnum.PASSWORD.getValue(), appId, appSecret, "", username, password, "", "", "");
        return Result.createSuccess((Object)rpcAccessToken);
    }

    public Result<RpcAccessToken> getAccessToken(String serverUrl, String appId, String appSecret, String username, String password, String uuid, String code) {
        RpcAccessToken rpcAccessToken = this.oauth2Service.getAccessToken(GrantTypeEnum.PASSWORD_CAPTCHA.getValue(), appId, appSecret, "", username, password, "", uuid, code);
        return Result.createSuccess((Object)rpcAccessToken);
    }

    public Result<RpcAccessToken> getAccessTokenBySms(String serverUrl, String appId, String appSecret, String tel, String uuid, String code) {
        RpcAccessToken rpcAccessToken = this.oauth2Service.getAccessToken(GrantTypeEnum.TEL_CAPTCHA.getValue(), appId, appSecret, "", "", "", tel, uuid, code);
        return Result.createSuccess((Object)rpcAccessToken);
    }

    public Result<RpcAccessToken> getAccessTokenByOne(String serverUrl, String appId, String appSecret, String processId, String token, String authCode) {
        RpcAccessToken rpcAccessToken = this.oauth2Service.getAccessToken(GrantTypeEnum.ONE.getValue(), appId, appSecret, "", "", "", "", "", "", "", "", processId, token, authCode);
        return Result.createSuccess((Object)rpcAccessToken);
    }

    public Result<RpcAccessToken> getAccessTokenByCa(String serverUrl, String appId, String appSecret, String caUserCert, String caOauthName) {
        RpcAccessToken rpcAccessToken = this.oauth2Service.getAccessToken(GrantTypeEnum.CA.getValue(), appId, appSecret, "", "", "", "", "", "", caUserCert, caOauthName, "", "", "");
        return Result.createSuccess((Object)rpcAccessToken);
    }

    public Result<RpcAccessToken> getAccessTokenByCode(String serverUrl, String appId, String appSecret, String code) {
        RpcAccessToken rpcAccessToken = this.oauth2Service.getAccessToken(GrantTypeEnum.AUTHORIZATION_CODE.getValue(), appId, appSecret, code, "", "", "", "", "");
        if (rpcAccessToken == null) {
            return Result.createError((String)"\u83b7\u53d6token\u5931\u8d25");
        }
        return Result.createSuccess((Object)rpcAccessToken);
    }

    public Result<RpcAccessToken> refreshToken(String serverUrl, String appId, String refreshToken) {
        RpcAccessToken rpcAccessToken = this.oauth2Service.refreshToken(appId, refreshToken);
        if (rpcAccessToken == null) {
            return Result.createError((String)"\u5237\u65b0token\u5931\u8d25");
        }
        return Result.createSuccess((Object)rpcAccessToken);
    }

    public Result<RpcAccessToken> queryAccessToken(String serverUrl, String accessToken) {
        RpcAccessToken rpcAccessToken = this.oauth2Service.queryAccessToken(accessToken);
        if (rpcAccessToken != null) {
            return Result.createSuccess((Object)rpcAccessToken);
        }
        return Result.createError((String)"\u83b7\u53d6token\u5931\u8d25");
    }

    public Result<RpcAccessToken> revokeAccessToken(String serverUrl, String accessToken) {
        this.oauth2Service.revokeAccessToken(accessToken);
        return Result.createSuccess();
    }

    public Result<String> getAccessCode(String serverUrl, String appId, String appSecret, String accessToken) {
        String code = this.oauth2Service.getAccessCode(appId, appSecret, accessToken);
        return Result.createSuccess((Object)code);
    }
}

