/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.lang.tree.TreeNodeConfig;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.jckj.base.support.BaseTreeUtil;
import com.geoway.jckj.base.support.StringUtils;
import com.geoway.jckj.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.jckj.base.support.spring.SpringUtils;
import com.geoway.jckj.biz.entity.SysMenu;
import com.geoway.jckj.biz.entity.SysSubFunction;
import com.geoway.jckj.biz.entity.SysTenantSubFunction;
import com.geoway.jckj.biz.mapper.SysSubFunctionMapper;
import com.geoway.jckj.biz.service.sys.SysMenuService;
import com.geoway.jckj.biz.service.sys.SysSubFunctionService;
import com.geoway.jckj.biz.util.TenantUtil;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SysSubFunctionServiceImpl
extends MPJBaseServiceImpl<SysSubFunctionMapper, SysSubFunction>
implements SysSubFunctionService {
    final String rootPid = "0";
    private final TreeNodeConfig treeNodeConfig = new TreeNodeConfig().setParentIdKey("pid").setIdKey("id");

    @Override
    public void batchSave(List<SysSubFunction> sysSubFunctions) {
        if (sysSubFunctions.size() == 0) {
            return;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysSubFunction::getSystemId, (Object)sysSubFunctions.get(0).getSystemId());
        wrapper.eq(SysSubFunction::getMenuId, (Object)sysSubFunctions.get(0).getMenuId());
        List exsistFunctions = this.list((Wrapper)wrapper);
        sysSubFunctions.removeIf(f -> exsistFunctions.stream().anyMatch(g -> g.getName().equalsIgnoreCase(f.getName()) || g.getKey().equalsIgnoreCase(f.getKey())));
        if (sysSubFunctions.size() == 0) {
            return;
        }
        this.saveBatch(sysSubFunctions);
    }

    @Override
    public void saveOrUp(SysSubFunction subFunction) throws Exception {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysSubFunction::getName, (Object)subFunction.getName());
        wrapper.eq(SysSubFunction::getSystemId, (Object)subFunction.getSystemId());
        wrapper.eq(SysSubFunction::getMenuId, (Object)subFunction.getMenuId());
        int iCount = this.count((Wrapper)wrapper);
        if (iCount > 0) {
            throw new Exception("\u529f\u80fd\u70b9: " + subFunction.getName() + "  \u5df2\u5b58\u5728\uff01");
        }
        this.saveOrUpdate(subFunction);
    }

    @Override
    public List<SysSubFunction> query(String filterParam) throws Exception {
        MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysSubFunction.class);
        List list = this.list((Wrapper)queryWrapper);
        List trees = BaseTreeUtil.listToTree((List)list, (TreeNodeConfig)this.treeNodeConfig, (String)"0");
        return trees;
    }

    @Override
    public List<SysSubFunction> queryByMenuId(String menuId) {
        SysMenuService sysMenuService = (SysMenuService)SpringUtils.getBean(SysMenuService.class);
        SysMenu registerMenu = sysMenuService.queryRegisterMenu(menuId);
        if (registerMenu == null) {
            return new ArrayList<SysSubFunction>();
        }
        String curTenantId = TenantUtil.getTenantId();
        MPJLambdaWrapper wrapper = MPJWrappers.lambdaJoin();
        wrapper.eq(SysSubFunction::getMenuId, (Object)registerMenu.getId());
        if (StringUtils.isNotEmpty((String)curTenantId) && !registerMenu.getTenantid().equals(curTenantId)) {
            wrapper.leftJoin(SysTenantSubFunction.class, SysTenantSubFunction::getSubfunctionid, SysSubFunction::getId);
            wrapper.eq(SysTenantSubFunction::getTenantid, (Object)curTenantId);
            wrapper.distinct();
        }
        List list = this.list((Wrapper)wrapper);
        List trees = BaseTreeUtil.listToTree((List)list, (TreeNodeConfig)this.treeNodeConfig, (String)"0");
        return trees;
    }

    @Override
    public void batchDelete(String ids) throws Exception {
        List<String> idList = Arrays.asList(ids.split(","));
        for (String id : idList) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysSubFunction::getPid, (Object)id);
            int iCount = this.count((Wrapper)wrapper);
            if (iCount <= 0) continue;
            throw new Exception("\u529f\u80fd\u70b9: " + id + "  \u5b58\u5728\u5b50\u529f\u80fd\u70b9\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        this.removeByIds(idList);
    }
}

