/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.biz.entity.SysMenu;
import com.geoway.jckj.biz.entity.SysRoleMenu;
import com.geoway.jckj.biz.entity.SysRoleSubfunction;
import com.geoway.jckj.biz.entity.SysSubFunction;
import com.geoway.jckj.biz.mapper.SysMenuMapper;
import com.geoway.jckj.biz.mapper.SysRoleMenuMapper;
import com.geoway.jckj.biz.mapper.SysSubFunctionMapper;
import com.geoway.jckj.biz.service.sys.SysRoleMenuService;
import com.geoway.jckj.biz.service.sys.SysRoleSubFunctionService;
import com.geoway.jckj.biz.service.sys.SysSubFunctionService;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.toolkit.JoinWrappers;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysRoleMenuServiceImpl
extends ServiceImpl<SysRoleMenuMapper, SysRoleMenu>
implements SysRoleMenuService {
    @Autowired
    SysMenuMapper sysMenuMapper;
    @Autowired
    SysSubFunctionMapper sysSubFunctionMapper;
    @Autowired
    SysRoleSubFunctionService sysRoleSubfunctionService;
    @Autowired
    SysSubFunctionService sysSubFunctionService;

    @Override
    public List<SysMenu> queryRelateMenus(String roleId, String appId) {
        MPJLambdaWrapper wrapper = MPJWrappers.lambdaJoin();
        wrapper.leftJoin(SysRoleMenu.class, SysRoleMenu::getMenuid, SysMenu::getId);
        wrapper.eq(SysRoleMenu::getRoleid, (Object)roleId);
        wrapper.eq(SysMenu::getSystemId, (Object)appId);
        return this.sysMenuMapper.selectJoinList(SysMenu.class, (MPJBaseJoin)wrapper);
    }

    @Override
    public void saveRoleMenus(String roleId, String appId, List<String> menuIds) {
        List systemMenuIds = this.sysMenuMapper.selectList((Wrapper)Wrappers.lambdaQuery(SysMenu.class).eq(SysMenu::getSystemId, (Object)appId)).stream().map(f -> f.getId()).collect(Collectors.toList());
        if (systemMenuIds.size() > 0) {
            this.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysRoleMenu.class).eq(SysRoleMenu::getRoleid, (Object)roleId)).in(SysRoleMenu::getMenuid, systemMenuIds));
        }
        if (menuIds.size() > 0) {
            ArrayList<SysRoleMenu> roleMenus = new ArrayList<SysRoleMenu>();
            for (String menuId : menuIds) {
                SysRoleMenu roleMenu = new SysRoleMenu();
                roleMenu.setMenuid(menuId);
                roleMenu.setRoleid(roleId);
                roleMenus.add(roleMenu);
            }
            this.saveBatch(roleMenus);
        }
    }

    @Override
    public List<SysSubFunction> queryRelateSubFunctions(String roleId, String menuId) {
        if (StrUtil.isBlank((CharSequence)roleId) || StrUtil.isBlank((CharSequence)menuId)) {
            return new ArrayList<SysSubFunction>();
        }
        List<String> roleIds = Arrays.asList(roleId.split(","));
        MPJLambdaWrapper wrapper = MPJWrappers.lambdaJoin();
        wrapper.leftJoin(SysRoleSubfunction.class, SysRoleSubfunction::getSubfunctionid, SysSubFunction::getId);
        wrapper.in(SysRoleSubfunction::getRoleid, roleIds);
        wrapper.eq(SysRoleSubfunction::getMenuId, (Object)menuId);
        wrapper.distinct();
        return this.sysSubFunctionMapper.selectJoinList(SysSubFunction.class, (MPJBaseJoin)wrapper);
    }

    @Override
    public void saveRoleSubFunctions(String roleId, String menuId, List<String> subFunctionIds) {
        List menuSubFunctionIds = this.sysSubFunctionService.queryByMenuId(menuId).stream().map(f -> f.getId()).collect(Collectors.toList());
        this.sysRoleSubfunctionService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysRoleSubfunction.class).eq(SysRoleSubfunction::getRoleid, (Object)roleId)).in(SysRoleSubfunction::getSubfunctionid, menuSubFunctionIds));
        if (subFunctionIds.size() > 0) {
            ArrayList<SysRoleSubfunction> sysRoleSubfunctions = new ArrayList<SysRoleSubfunction>();
            for (String subFunctionId : subFunctionIds) {
                SysRoleSubfunction sysSubFunction = new SysRoleSubfunction();
                sysSubFunction.setSubfunctionid(subFunctionId);
                sysSubFunction.setRoleid(roleId);
                sysSubFunction.setMenuId(menuId);
                sysRoleSubfunctions.add(sysSubFunction);
            }
            this.sysRoleSubfunctionService.saveBatch(sysRoleSubfunctions);
        }
    }

    @Override
    public void removeRelateMenus(String roleId, String appId) {
        MPJLambdaWrapper joinQueryWrapper = JoinWrappers.lambda();
        joinQueryWrapper.leftJoin(SysMenu.class, SysMenu::getId, SysRoleMenu::getMenuid);
        joinQueryWrapper.eq(SysMenu::getSystemId, (Object)appId);
        joinQueryWrapper.eq(SysRoleMenu::getRoleid, (Object)roleId);
        List roleMenus = ((SysRoleMenuMapper)this.baseMapper).selectJoinList(SysRoleMenu.class, (MPJBaseJoin)joinQueryWrapper);
        if (roleMenus.size() > 0) {
            List roleMenuIds = roleMenus.stream().map(i -> i.getId()).collect(Collectors.toList());
            this.removeByIds(roleMenuIds);
        }
    }
}

