/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.biz.entity.SysBizManageOrganization;
import com.geoway.jckj.biz.entity.SysOrganization;
import com.geoway.jckj.biz.mapper.SysBizManageOrganizationMapper;
import com.geoway.jckj.biz.service.dev.unity.IUnityOrganizationService;
import com.geoway.jckj.biz.service.sys.SysBizManageOrganizationService;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysBizManageOrganizationServiceImpl
extends MPJBaseServiceImpl<SysBizManageOrganizationMapper, SysBizManageOrganization>
implements SysBizManageOrganizationService {
    @Autowired
    IUnityOrganizationService organizationService;

    @Override
    public List<SysOrganization> queryBindOrgs(String bizManageId) {
        try {
            MPJLambdaWrapper queryWrapper = MPJWrappers.lambdaJoin();
            queryWrapper.eq(SysBizManageOrganization::getBizManageId, (Object)bizManageId);
            List sysBizManageOrganizations = this.list((Wrapper)queryWrapper);
            ArrayList<SysOrganization> orgs = new ArrayList<SysOrganization>();
            List orgIds = sysBizManageOrganizations.stream().map(f -> f.getOrgId()).collect(Collectors.toList());
            for (String orgId : orgIds) {
                SysOrganization sysOrganization = this.organizationService.findOneById(orgId, "");
                if (sysOrganization == null) continue;
                sysOrganization.setChildren(null);
                orgs.add(sysOrganization);
            }
            return orgs;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public void bindOrgs(String bizManageId, String orgIds) {
        LambdaQueryWrapper menuWrapper = Wrappers.lambdaQuery();
        menuWrapper.eq(SysBizManageOrganization::getBizManageId, (Object)bizManageId);
        this.remove((Wrapper)menuWrapper);
        if (StrUtil.isBlank((CharSequence)orgIds)) {
            return;
        }
        List<String> orgIdList = Arrays.asList(orgIds.split(","));
        ArrayList<SysBizManageOrganization> bizManageOrganizations = new ArrayList<SysBizManageOrganization>();
        for (String orgId : orgIdList) {
            SysBizManageOrganization bizManageOrganization = new SysBizManageOrganization();
            bizManageOrganization.setOrgId(orgId);
            bizManageOrganization.setBizManageId(bizManageId);
            bizManageOrganizations.add(bizManageOrganization);
        }
        this.saveBatch(bizManageOrganizations);
    }
}

