/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.jckj.biz.entity.SysBizManage;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.entity.SysUserCatalog;
import com.geoway.jckj.biz.mapper.SysBizManageMapper;
import com.geoway.jckj.biz.service.dev.unity.IUnityBizManageService;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserService;
import com.geoway.jckj.biz.service.sys.SysBizManageOrganizationService;
import com.geoway.jckj.biz.service.sys.SysBizManageRegionService;
import com.geoway.jckj.biz.service.sys.SysBizManageRoleService;
import com.geoway.jckj.biz.service.sys.SysBizManageService;
import com.geoway.jckj.biz.service.sys.SysUserCatalogService;
import com.geoway.sso.client.enums.RoleLevelEnum;
import com.github.yulichang.base.MPJBaseServiceImpl;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysBizManageServiceImpl
extends MPJBaseServiceImpl<SysBizManageMapper, SysBizManage>
implements SysBizManageService {
    @Autowired
    private SysBizManageOrganizationService sysBizManageOrganizationService;
    @Autowired
    private SysBizManageRoleService sysBizManageRoleService;
    @Autowired
    private SysBizManageRegionService sysBizManageRegionService;
    @Autowired
    private IUnityUserService unityUserService;
    @Autowired
    private IUnityBizManageService unityBizManageService;
    @Autowired
    private SysUserCatalogService sysUserCatalogService;

    @Override
    public boolean add(String userIds) {
        if (StrUtil.isBlank((CharSequence)userIds)) {
            return true;
        }
        List<String> userIdList = Arrays.asList(userIds.split(","));
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(SysBizManage::getUserId, userIdList);
        List exists = this.list((Wrapper)wrapper).stream().map(f -> f.getUserId()).collect(Collectors.toList());
        userIdList.removeIf(f -> exists.contains(f));
        if (userIdList.size() == 0) {
            return true;
        }
        for (String userId : userIdList) {
            SysUser sysUser = this.unityUserService.query(userId);
            SysBizManage sysBizManage = new SysBizManage();
            sysBizManage.setCreatetime(new Date());
            sysBizManage.setUserId(sysUser.getId());
            this.save(sysBizManage);
            if (sysUser.getOrganizations() != null && sysUser.getOrganizations().size() > 0) {
                this.sysBizManageOrganizationService.bindOrgs(sysBizManage.getId(), sysUser.getOrganizations().stream().map(f -> f.getId()).collect(Collectors.joining(",")));
            }
            if (sysUser.getRoles() != null && sysUser.getRoles().size() > 0) {
                this.sysBizManageRoleService.bindRoles(sysBizManage.getId(), sysUser.getRoles().stream().map(f -> f.getId()).collect(Collectors.joining(",")));
            }
            if (sysUser.getRegions() != null && sysUser.getRegions().size() > 0) {
                this.sysBizManageRegionService.bindRegions(sysBizManage.getId(), sysUser.getRegions().stream().map(f -> f.getId()).collect(Collectors.joining(",")));
            }
            SysUserCatalog sysUserCatalog = new SysUserCatalog();
            sysUserCatalog.setUserid(sysUser.getId());
            sysUserCatalog.setUserCatalog(RoleLevelEnum.bizAdmin.getValue());
            this.sysUserCatalogService.saveOrUp(sysUserCatalog);
        }
        return true;
    }

    @Override
    public void delete(String ids) {
        if (StrUtil.isBlank((CharSequence)ids)) {
            return;
        }
        List<String> idList = Arrays.asList(ids.split(","));
        for (String id : idList) {
            SysBizManage sysBizManage = (SysBizManage)this.getById((Serializable)((Object)id));
            if (sysBizManage == null) {
                return;
            }
            this.removeById((Serializable)((Object)id));
            this.sysBizManageOrganizationService.bindOrgs(id, "");
            this.sysBizManageRoleService.bindRoles(id, "");
            this.sysBizManageRegionService.bindRegions(id, "");
            SysUserCatalog sysUserCatalog = new SysUserCatalog();
            sysUserCatalog.setUserid(sysBizManage.getUserId());
            sysUserCatalog.setUserCatalog(RoleLevelEnum.commonUser.getValue());
            this.sysUserCatalogService.saveOrUp(sysUserCatalog);
            this.sysUserCatalogService.saveOrUp(sysUserCatalog);
        }
    }

    @Override
    public IPage<SysBizManage> queryPage(String filterParam, Integer page, Integer size) {
        IPage<SysBizManage> pageResult = this.unityBizManageService.queryPage(filterParam, page, size);
        pageResult.getRecords().forEach(f -> {
            f.setRegions(this.sysBizManageRegionService.queryBindRegions(f.getId()));
            f.setOrganizations(this.sysBizManageOrganizationService.queryBindOrgs(f.getId()));
            f.setSysRoles(this.sysBizManageRoleService.queryBindRoles(f.getId()));
        });
        return pageResult;
    }

    @Override
    public SysBizManage queryByUserId(String userId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysBizManage::getUserId, (Object)userId);
        SysBizManage sysBizManage = (SysBizManage)this.getOne((Wrapper)wrapper);
        if (sysBizManage == null) {
            return null;
        }
        sysBizManage.setRegions(this.sysBizManageRegionService.queryBindRegions(sysBizManage.getId()));
        sysBizManage.setOrganizations(this.sysBizManageOrganizationService.queryBindOrgs(sysBizManage.getId()));
        sysBizManage.setSysRoles(this.sysBizManageRoleService.queryBindRoles(sysBizManage.getId()));
        return sysBizManage;
    }
}

