/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.base.support.StringUtils;
import com.geoway.jckj.biz.entity.SysRegion;
import com.geoway.jckj.biz.entity.SysTenantRegion;
import com.geoway.jckj.biz.mapper.SysTenantRegionMapper;
import com.geoway.jckj.biz.service.sys.SysRegionService;
import com.geoway.jckj.biz.service.sys.SysTenantRegionService;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysTenantRegionServiceImpl
extends ServiceImpl<SysTenantRegionMapper, SysTenantRegion>
implements SysTenantRegionService {
    @Autowired
    SysRegionService sysRegionService;

    @Override
    public List<SysRegion> queryBindRegions(String tenantId) {
        MPJLambdaWrapper queryWrapper = MPJWrappers.lambdaJoin();
        queryWrapper.leftJoin(SysTenantRegion.class, SysTenantRegion::getRegionid, SysRegion::getId);
        queryWrapper.eq(SysTenantRegion::getTenantid, (Object)tenantId);
        return this.sysRegionService.list((Wrapper)queryWrapper);
    }

    @Override
    public void bindRegions(String tenantId, List<String> regionIds) {
        LambdaQueryWrapper menuWrapper = Wrappers.lambdaQuery();
        menuWrapper.eq(SysTenantRegion::getTenantid, (Object)tenantId);
        this.remove((Wrapper)menuWrapper);
        ArrayList<SysTenantRegion> regions = new ArrayList<SysTenantRegion>();
        for (String regionId : regionIds) {
            SysTenantRegion sysTenantRegion = new SysTenantRegion();
            sysTenantRegion.setRegionid(regionId);
            sysTenantRegion.setTenantid(tenantId);
            regions.add(sysTenantRegion);
        }
        this.saveBatch(regions);
    }

    @Override
    public void bindRegions(String tenantId, String regionIds) {
        if (StringUtils.isEmpty((String)regionIds)) {
            regionIds = "";
        }
        String[] regionIdArr = regionIds.split(",");
        this.bindRegions(tenantId, Arrays.asList(regionIdArr));
    }
}

