/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.StringUtils;
import com.geoway.jckj.base.support.query.MPJQueryMapperUtil;
import com.geoway.jckj.biz.entity.SysOrganization;
import com.geoway.jckj.biz.entity.SysRegion;
import com.geoway.jckj.biz.entity.SysSystem;
import com.geoway.jckj.biz.entity.SysTenant;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.entity.SysUserTenant;
import com.geoway.jckj.biz.mapper.SysTenantMapper;
import com.geoway.jckj.biz.service.sys.SysTenantOrganizationService;
import com.geoway.jckj.biz.service.sys.SysTenantRegionService;
import com.geoway.jckj.biz.service.sys.SysTenantService;
import com.geoway.jckj.biz.service.sys.SysTenantSystemService;
import com.geoway.jckj.biz.service.sys.SysUserTenantService;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysTenantServiceImpl
extends MPJBaseServiceImpl<SysTenantMapper, SysTenant>
implements SysTenantService {
    @Autowired
    private SysUserTenantService sysUserTenantService;
    @Autowired
    private SysTenantRegionService sysTenantRegionService;
    @Autowired
    private SysTenantOrganizationService sysTenantOrganizationService;
    @Autowired
    private SysTenantSystemService sysTenantSystemService;

    @Override
    public boolean saveOrUp(SysTenant sysTenant) {
        Integer one;
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysTenant::getName, (Object)sysTenant.getName());
        if (StrUtil.isNotBlank((CharSequence)sysTenant.getId())) {
            wrapper.ne(SysTenant::getId, (Object)sysTenant.getId());
        }
        if ((one = Integer.valueOf(this.count((Wrapper)wrapper))) > 0) {
            throw new ServiceException("\u540d\u79f0\u3010" + sysTenant.getName() + "\u3011\u5df2\u5b58\u5728\uff01");
        }
        ((LambdaQueryWrapper)wrapper.or()).eq(SysTenant::getKey, (Object)sysTenant.getKey());
        one = this.count((Wrapper)wrapper);
        if (one > 0) {
            throw new ServiceException("\u5173\u952e\u5b57\u3010" + sysTenant.getKey() + "\u3011\u5df2\u5b58\u5728\uff01");
        }
        if (StringUtils.isEmpty((String)sysTenant.getId())) {
            sysTenant.setId("gw" + System.currentTimeMillis());
        }
        return this.saveOrUpdate(sysTenant);
    }

    public SysTenant getById(Serializable id) {
        SysTenant sysTenant = (SysTenant)((SysTenantMapper)this.getBaseMapper()).selectById(id);
        if (sysTenant == null) {
            return sysTenant;
        }
        this.wapperSysTenant(sysTenant);
        return sysTenant;
    }

    @Override
    @Transactional
    public void delete(String id) {
        List users = this.sysUserTenantService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysUserTenant.class).eq(SysUserTenant::getTenantid, (Object)id)).select(new SFunction[]{SysUserTenant::getUserid}));
        this.sysUserTenantService.removeBindUsers(id, users.stream().map(SysUserTenant::getUserid).collect(Collectors.joining(",")));
        this.removeById((Serializable)((Object)id));
    }

    private MPJLambdaWrapper<SysTenant> buildMPJLambdaWrapper(String filterParam) {
        try {
            MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
            MPJLambdaWrapper queryWrapper = qmu.queryMapper(filterParam, SysTenant.class);
            queryWrapper.orderByAsc(SysTenant::getCreatetime);
            queryWrapper.leftJoin(SysUserTenant.class, SysUserTenant::getTenantid, SysTenant::getId);
            queryWrapper.selectAll(SysTenant.class);
            queryWrapper.distinct();
            return queryWrapper;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private void wapperSysTenants(List<SysTenant> tenants) {
        tenants.forEach(f -> this.wapperSysTenant((SysTenant)f));
    }

    private void wapperSysTenant(SysTenant tenant) {
        List<SysSystem> systemNames = this.sysTenantSystemService.queryBindSystems(tenant.getId());
        tenant.setSystems(systemNames);
        List<SysUser> sysUsers = this.sysUserTenantService.queryBindUsers(tenant.getId());
        tenant.setUsers(sysUsers);
        List<SysRegion> sysRegions = this.sysTenantRegionService.queryBindRegions(tenant.getId());
        tenant.setRegions(sysRegions);
        List<SysOrganization> sysOrganizations = this.sysTenantOrganizationService.queryBindOrgs(tenant.getId());
        tenant.setOrganizations(sysOrganizations);
    }

    @Override
    public IPage<SysTenant> queryPage(String filterParam, Integer page, Integer size) throws Exception {
        MPJLambdaWrapper<SysTenant> queryWrapper = this.buildMPJLambdaWrapper(filterParam);
        Page pages = new Page((long)page.intValue(), (long)size.intValue());
        IPage pageTenants = this.selectJoinListPage((IPage)pages, SysTenant.class, (MPJBaseJoin)queryWrapper);
        this.wapperSysTenants(pageTenants.getRecords());
        return pageTenants;
    }

    @Override
    public SysTenant queryByKey(String key) {
        MPJLambdaWrapper queryWrapper = MPJWrappers.lambdaJoin();
        queryWrapper.eq(SysTenant::getKey, (Object)key);
        SysTenant sysTenant = (SysTenant)this.getOne((Wrapper)queryWrapper);
        if (sysTenant == null) {
            return sysTenant;
        }
        this.wapperSysTenant(sysTenant);
        return sysTenant;
    }

    @Override
    public List<SysTenant> queryByUserId(String userId) {
        MPJLambdaWrapper<SysTenant> queryWrapper = this.buildMPJLambdaWrapper("");
        queryWrapper.eq(SysUserTenant::getUserid, (Object)userId);
        List sysTenants = this.selectJoinList(SysTenant.class, (MPJBaseJoin)queryWrapper);
        this.wapperSysTenants(sysTenants);
        return sysTenants;
    }
}

