/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.date.DateUtil;
import com.geoway.jckj.biz.config.PasswordConfig;
import com.geoway.jckj.biz.entity.SysUserLock;
import com.geoway.jckj.biz.mapper.SysUserLockMapper;
import com.geoway.jckj.biz.service.sys.SysUserLockService;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class SysUserLockServiceImpl
implements SysUserLockService {
    private static final Logger log = LoggerFactory.getLogger(SysUserLockServiceImpl.class);
    @Autowired
    private SysUserLockMapper sysUserLockMapper;
    @Autowired
    private PasswordConfig passwordConfig;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    private final String ERROR_PREFIX = "errPwdTimes-";

    @Override
    public String lockUserIfMultipleError(String username) {
        if (!this.passwordConfig.getSecurityEnable().booleanValue()) {
            return "";
        }
        boolean existEntity = true;
        SysUserLock sysUserLock = (SysUserLock)this.sysUserLockMapper.selectById((Serializable)((Object)username));
        if (sysUserLock == null) {
            existEntity = false;
            sysUserLock = new SysUserLock();
            sysUserLock.setName(username);
        }
        sysUserLock.setLastfailedtime(new Date());
        sysUserLock.addOneFailureTimes();
        int errorCount = this.checkedIsErrpasswordInDuration(username);
        int remainingChances = this.passwordConfig.getAllowFailureTimes() - errorCount;
        if (remainingChances == 0) {
            sysUserLock.lock(this.passwordConfig.getAutoUnlockMinute());
            String key = "errPwdTimes-" + username;
            this.redisTemplate.delete((Object)key);
        }
        if (existEntity) {
            this.sysUserLockMapper.updateById(sysUserLock);
        } else {
            this.sysUserLockMapper.insert(sysUserLock);
        }
        if (remainingChances > 0) {
            return "\u5269\u4f59\u673a\u4f1a\uff1a" + remainingChances + " \u6b21\uff0c\u9519\u6ee1\u5c06\u9501\u5b9a\u3002";
        }
        if (remainingChances == 0) {
            return "\u7528\u6237\u5df2\u88ab\u9501\u5b9a\uff0c\u7cfb\u7edf\u5c06\u4e8e" + DateUtil.format((Date)sysUserLock.getUnlocktime(), (String)"yyyy-MM-dd HH:mm:ss") + "\u540e\u81ea\u52a8\u89e3\u9501";
        }
        return "";
    }

    @Override
    public String checkUserLocked(String username) {
        if (!this.passwordConfig.getSecurityEnable().booleanValue()) {
            return null;
        }
        SysUserLock sysUserLock = (SysUserLock)this.sysUserLockMapper.selectById((Serializable)((Object)username));
        if (sysUserLock == null) {
            return null;
        }
        Date now = new Date();
        if (Objects.equals(sysUserLock.getLock(), 1) && sysUserLock.getUnlocktime() != null && sysUserLock.getUnlocktime().after(now)) {
            String timeMsg = DateUtil.format((Date)sysUserLock.getUnlocktime(), (String)"yyyy-MM-dd HH:mm:ss");
            return timeMsg;
        }
        return null;
    }

    @Override
    public void unLockUser(String username) {
        if (!this.passwordConfig.getSecurityEnable().booleanValue()) {
            return;
        }
        SysUserLock sysUserLock = (SysUserLock)this.sysUserLockMapper.selectById((Serializable)((Object)username));
        if (sysUserLock != null && sysUserLock.getLock() == 1) {
            sysUserLock.unlock();
            this.sysUserLockMapper.updateById(sysUserLock);
        }
    }

    private Integer checkedIsErrpasswordInDuration(String username) {
        int errorCount = 1;
        String key = "errPwdTimes-" + username;
        boolean hasKey = this.redisTemplate.hasKey((Object)key);
        if (hasKey) {
            String strNum = (String)this.redisTemplate.opsForValue().get((Object)key);
            Integer num = Integer.parseInt(strNum);
            if (num < this.passwordConfig.getAllowFailureTimes()) {
                num = num + 1;
                errorCount = num;
                this.redisTemplate.opsForValue().set((Object)key, (Object)(num + ""));
            }
        } else {
            this.redisTemplate.opsForValue().set((Object)key, (Object)"1");
            this.redisTemplate.expire((Object)key, 5L, TimeUnit.MINUTES);
        }
        return errorCount;
    }
}

