/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.plugin;

import cn.hutool.core.io.FileUtil;
import com.geoway.jckj.base.support.spring.SpringUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Component
public class PluginImportService {
    @Value(value="${plugin.enable:true}")
    private boolean enable = true;
    @Value(value="${plugin.pluginPath:plugins}")
    private String pluginPath;
    private ApplicationContext applicationContext;
    private DefaultListableBeanFactory defaultListableBeanFactory;

    public void importPlugins() {
        String curProjectPath;
        String pluginAbsolutePath;
        File pluginFile;
        this.initContext();
        if (!this.enable) {
            return;
        }
        if (StringUtils.isEmpty((Object)this.pluginPath)) {
            this.pluginPath = "plugins";
        }
        if (!(pluginFile = new File(pluginAbsolutePath = (curProjectPath = System.getProperty("user.dir")) + File.separator + this.pluginPath)).isDirectory() || !pluginFile.exists()) {
            return;
        }
        File[] jarFiles = pluginFile.listFiles((dir, name) -> name.endsWith(".jar"));
        if (jarFiles.length == 0) {
            return;
        }
        System.out.println(" <---------------\u5f00\u59cb\u70ed\u52a0\u8f7djar\u5305 ---------------> ");
        try {
            for (File jarFile : jarFiles) {
                if (!this.loadJar(jarFile.getAbsolutePath())) {
                    System.out.println("******jar\u5305\u52a0\u8f7d\u5931\u8d25\uff1a" + jarFile.getAbsolutePath());
                    continue;
                }
                if (!this.registerBean(jarFile)) {
                    System.out.println("******jar\u6ce8\u518c\u5931\u8d25\uff1a" + jarFile.getAbsolutePath());
                }
                System.out.println("******jar\u70ed\u52a0\u8f7d\u6210\u529f\uff1a" + jarFile.getAbsolutePath());
            }
            System.out.println(" <--------------- \u70ed\u52a0\u8f7djar\u5305\u7ed3\u675f ---------------> ");
        }
        catch (Exception e) {
            System.out.println(" <---------------\u70ed\u52a0\u8f7djar\u5305\u5f02\u5e38 ---------------> ");
            e.printStackTrace();
        }
    }

    private void initContext() {
        if (this.applicationContext != null) {
            return;
        }
        this.applicationContext = SpringUtils.getApplicationContext();
        ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)this.applicationContext;
        this.defaultListableBeanFactory = (DefaultListableBeanFactory)configurableApplicationContext.getBeanFactory();
    }

    private boolean loadJar(String jarPath) {
        try {
            URLClassLoader classLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
            Method add = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            if (!add.isAccessible()) {
                add.setAccessible(true);
            }
            File jarFile = FileUtil.file((String)jarPath);
            add.invoke((Object)classLoader, jarFile.toURI().toURL());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean registerBean(File file) {
        try {
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> en = jarFile.entries();
            while (en.hasMoreElements()) {
                JarEntry je = en.nextElement();
                String name = je.getName();
                if (!name.endsWith(".class")) continue;
                String className = name.replace(".class", "").replaceAll("/", ".");
                Class<?> clazz = Class.forName(className);
                this.insertBean(clazz);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void insertBean(Class<?> c) {
        if (this.isSpringBeanClass(c)) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(c);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            if (!this.defaultListableBeanFactory.containsBean(c.getName())) {
                this.defaultListableBeanFactory.registerBeanDefinition(c.getName(), (BeanDefinition)beanDefinition);
            }
        }
    }

    private boolean isSpringBeanClass(Class<?> cla) {
        if (cla == null) {
            return false;
        }
        if (cla.isInterface()) {
            return false;
        }
        if (Modifier.isAbstract(cla.getModifiers())) {
            return false;
        }
        if (cla.getAnnotation(Component.class) != null) {
            return true;
        }
        if (cla.getAnnotation(Repository.class) != null) {
            return true;
        }
        return cla.getAnnotation(Service.class) != null;
    }
}

