/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.login.impl;

import cn.hutool.captcha.AbstractCaptcha;
import cn.hutool.captcha.CaptchaUtil;
import cn.hutool.captcha.LineCaptcha;
import cn.hutool.core.util.StrUtil;
import com.geoway.jckj.base.support.RedisUtil;
import com.geoway.jckj.biz.service.login.ICaptchaService;
import com.geoway.sso.server.config.PropertyConfig;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="commonService")
public class CaptchaServiceImpl
implements ICaptchaService {
    @Value(value="${app.setting.captcha.length:4}")
    private int codeCount;
    @Value(value="${app.setting.captcha.width:96}")
    private int width;
    @Value(value="${app.setting.captcha.height:32}")
    private int height;
    char[] codeSequence = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    PropertyConfig propertyConfig;

    @Override
    public AbstractCaptcha createImageCaptcha(String imageWidth, String imageHeight) {
        if (StringUtils.isNotBlank((CharSequence)imageWidth)) {
            this.width = Integer.parseInt(imageWidth);
        }
        if (StringUtils.isNotBlank((CharSequence)imageHeight)) {
            this.height = Integer.parseInt(imageHeight);
        }
        LineCaptcha lineCaptcha = CaptchaUtil.createLineCaptcha((int)this.width, (int)this.height, (int)4, (int)20);
        return lineCaptcha;
    }

    @Override
    public void storeCaptcha(String sessionId, String captchaText) {
        String key = sessionId + "_captchaText";
        this.redisUtil.set(key, (Object)captchaText, 3L, TimeUnit.MINUTES);
    }

    @Override
    public String queryCaptcha(String sessionId) {
        String key = sessionId + "_captchaText";
        return (String)this.redisUtil.get(key);
    }

    @Override
    public void removeCaptcha(String sessionId) {
        String key = sessionId + "_captchaText";
        this.redisUtil.del(new String[]{key});
    }

    @Override
    public boolean validateCaptcha(String code, String storeCode) {
        Boolean isDev = this.propertyConfig.getRunMode().indexOf("dev") > -1;
        if (StrUtil.isBlank((CharSequence)storeCode) || StrUtil.isBlank((CharSequence)code)) {
            return false;
        }
        return !(isDev != false ? !code.equalsIgnoreCase(storeCode) && !code.equalsIgnoreCase("4567") : !code.equalsIgnoreCase(storeCode));
    }
}

