/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.login.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.geoway.jckj.base.support.QrCodeUtils;
import com.geoway.jckj.base.support.RedisUtil;
import com.geoway.jckj.biz.config.SsoConfig;
import com.geoway.jckj.biz.dto.QrLoginDTO;
import com.geoway.jckj.biz.service.login.IQrLoginService;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QrLoginServiceImpl
implements IQrLoginService {
    @Autowired
    SsoConfig ssoConfig;
    @Autowired
    private RedisUtil redisUtil;
    private static final String REDIS_QR_PREFIX = "QR_";

    @Override
    public QrLoginDTO generateQrCode() throws Exception {
        QrLoginDTO map = new QrLoginDTO();
        JSONObject qrCOntent = new JSONObject();
        try {
            String uidKey = REDIS_QR_PREFIX + UUID.randomUUID().toString();
            int timeout = this.ssoConfig.getQrTimeout();
            this.redisUtil.set(uidKey, (Object)"", (long)timeout);
            qrCOntent.put("key", (Object)uidKey);
            qrCOntent.put("expires", (Object)timeout);
            qrCOntent.put("timestamp", (Object)System.currentTimeMillis());
            String baseQr = QrCodeUtils.getBase64QRCode((String)qrCOntent.toJSONString());
            map.setQr(baseQr);
            map.setKey(uidKey);
            map.setTimestamp(System.currentTimeMillis());
            map.setExpires(timeout);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\u751f\u6210\u767b\u5f55\u4e8c\u7ef4\u7801\u5931\u8d25!");
        }
        return map;
    }

    @Override
    public SsoUser getLoginInfo(String key) throws Exception {
        String accessToken = (String)this.redisUtil.get(key);
        if (StrUtil.isNotEmpty((CharSequence)accessToken)) {
            SsoUser user = CommonLoginUserUtil.getUser((String)accessToken);
            user.setToken(accessToken);
            this.redisUtil.del(new String[]{key});
            return user;
        }
        return null;
    }

    @Override
    public Boolean autoLogin(String accessToken, String key) {
        if (this.redisUtil.hasKey(key)) {
            this.redisUtil.set(key, (Object)accessToken);
            return true;
        }
        return false;
    }
}

