/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.biz.entity.SysBizManageRegion;
import com.geoway.jckj.biz.entity.SysRegion;
import com.geoway.jckj.biz.mapper.SysBizManageRegionMapper;
import com.geoway.jckj.biz.service.sys.SysBizManageRegionService;
import com.geoway.jckj.biz.service.sys.SysRegionService;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysBizManageRegionServiceImpl
extends MPJBaseServiceImpl<SysBizManageRegionMapper, SysBizManageRegion>
implements SysBizManageRegionService {
    @Autowired
    SysRegionService sysRegionService;

    @Override
    public List<SysRegion> queryBindRegions(String bizManageId) {
        try {
            MPJLambdaWrapper queryWrapper = MPJWrappers.lambdaJoin();
            queryWrapper.leftJoin(SysBizManageRegion.class, SysBizManageRegion::getRegionid, SysRegion::getId);
            queryWrapper.eq(SysBizManageRegion::getBizManageId, (Object)bizManageId);
            return this.sysRegionService.list((Wrapper)queryWrapper);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public void bindRegions(String bizManageId, String regionIds) {
        LambdaQueryWrapper menuWrapper = Wrappers.lambdaQuery();
        menuWrapper.eq(SysBizManageRegion::getBizManageId, (Object)bizManageId);
        this.remove((Wrapper)menuWrapper);
        if (StrUtil.isBlank((CharSequence)regionIds)) {
            return;
        }
        List<String> idList = Arrays.asList(regionIds.split(","));
        ArrayList<SysBizManageRegion> bizManageRegions = new ArrayList<SysBizManageRegion>();
        for (String id : idList) {
            SysBizManageRegion bizManageRegion = new SysBizManageRegion();
            bizManageRegion.setRegionid(id);
            bizManageRegion.setBizManageId(bizManageId);
            bizManageRegions.add(bizManageRegion);
        }
        this.saveBatch(bizManageRegions);
    }
}

