/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.biz.entity.SysRoleSubfunction;
import com.geoway.jckj.biz.entity.SysSubFunction;
import com.geoway.jckj.biz.mapper.SysRoleSubfunctionMapper;
import com.geoway.jckj.biz.mapper.SysSubFunctionMapper;
import com.geoway.jckj.biz.service.sys.SysRoleSubFunctionService;
import com.geoway.jckj.biz.service.sys.SysSubFunctionService;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysRoleSubfunctionServiceImpl
extends ServiceImpl<SysRoleSubfunctionMapper, SysRoleSubfunction>
implements SysRoleSubFunctionService {
    @Autowired
    private SysSubFunctionService sysSubFunctionService;
    @Autowired
    private SysSubFunctionMapper sysSubFunctionMapper;

    @Override
    public List<SysSubFunction> queryRelateSubFunctionList(String roleId, String menuId) {
        if (StrUtil.isBlank((CharSequence)roleId) || StrUtil.isBlank((CharSequence)menuId)) {
            return new ArrayList<SysSubFunction>();
        }
        List<String> roleIds = Arrays.asList(roleId.split(","));
        MPJLambdaWrapper wrapper = MPJWrappers.lambdaJoin();
        wrapper.leftJoin(SysRoleSubfunction.class, SysRoleSubfunction::getSubfunctionid, SysSubFunction::getId);
        wrapper.in(SysRoleSubfunction::getRoleid, roleIds);
        wrapper.eq(SysRoleSubfunction::getMenuId, (Object)menuId);
        wrapper.distinct();
        List sysSubFunctions = this.sysSubFunctionMapper.selectJoinList(SysSubFunction.class, (MPJBaseJoin)wrapper);
        if (sysSubFunctions.size() == 0) {
            return sysSubFunctions;
        }
        wrapper.clear();
        wrapper.in(SysSubFunction::getPid, (Collection)sysSubFunctions.stream().map(f -> f.getId()).collect(Collectors.toList()));
        List pIds = this.sysSubFunctionMapper.selectList((Wrapper)wrapper).stream().map(f -> f.getPid()).collect(Collectors.toList());
        sysSubFunctions.removeIf(f -> pIds.contains(f.getId()));
        return sysSubFunctions;
    }

    @Override
    public List<SysSubFunction> queryRelateSubFunctionTree(String roleId, String menuId) {
        List<SysSubFunction> list = this.queryRelateSubFunctionList(roleId, menuId);
        return this.sysSubFunctionService.queryTree(list);
    }

    @Override
    public void saveRoleSubFunctions(String roleId, String menuId, List<String> subFunctionIds) {
        this.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysRoleSubfunction.class).eq(SysRoleSubfunction::getRoleid, (Object)roleId)).eq(SysRoleSubfunction::getMenuId, (Object)menuId));
        if (subFunctionIds != null && subFunctionIds.size() > 0) {
            ArrayList<SysRoleSubfunction> sysRoleSubfunctions = new ArrayList<SysRoleSubfunction>();
            for (String subFunctionId : subFunctionIds) {
                SysRoleSubfunction sysSubFunction = new SysRoleSubfunction();
                sysSubFunction.setSubfunctionid(subFunctionId);
                sysSubFunction.setRoleid(roleId);
                sysSubFunction.setMenuId(menuId);
                sysRoleSubfunctions.add(sysSubFunction);
            }
            this.saveBatch(sysRoleSubfunctions);
        }
    }
}

