/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.biz.entity.SysSubFunction;
import com.geoway.jckj.biz.entity.SysTenant;
import com.geoway.jckj.biz.entity.SysTenantSubFunction;
import com.geoway.jckj.biz.mapper.SysSubFunctionMapper;
import com.geoway.jckj.biz.mapper.SysTenantMapper;
import com.geoway.jckj.biz.mapper.SysTenantSubfunctionMapper;
import com.geoway.jckj.biz.service.sys.SysRoleSubFunctionService;
import com.geoway.jckj.biz.service.sys.SysRoleSystemService;
import com.geoway.jckj.biz.service.sys.SysTenantSubFunctionService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysTenantSubFunctionServiceImpl
extends ServiceImpl<SysTenantSubfunctionMapper, SysTenantSubFunction>
implements SysTenantSubFunctionService {
    @Autowired
    private SysTenantMapper sysTenantMapper;
    @Autowired
    SysRoleSystemService sysRoleSystemService;
    @Autowired
    SysRoleSubFunctionService saveRoleSubFunctions;
    @Autowired
    SysSubFunctionMapper sysSubFunctionMapper;

    @Override
    public void bindSubFunctions(String tenantId, String menuId, String subFunctionIds) {
        List<String> idArr = Arrays.asList(subFunctionIds.split(","));
        LambdaQueryWrapper menuWrapper = Wrappers.lambdaQuery();
        menuWrapper.eq(SysTenantSubFunction::getTenantid, (Object)tenantId);
        menuWrapper.eq(SysTenantSubFunction::getMenuid, (Object)menuId);
        SysTenant sysTenant = (SysTenant)this.sysTenantMapper.selectById((Serializable)((Object)tenantId));
        if (StrUtil.isNotBlank((CharSequence)sysTenant.getDefaultRoleId())) {
            this.saveRoleSubFunctions.saveRoleSubFunctions(sysTenant.getDefaultRoleId(), menuId, idArr);
        }
        this.remove((Wrapper)menuWrapper);
        ArrayList<SysTenantSubFunction> subFunctions = new ArrayList<SysTenantSubFunction>();
        for (String subFunctionId : idArr) {
            SysTenantSubFunction subFunction = new SysTenantSubFunction();
            subFunction.setMenuid(menuId);
            subFunction.setTenantid(tenantId);
            subFunction.setSubfunctionid(subFunctionId);
            subFunctions.add(subFunction);
        }
        this.saveBatch(subFunctions);
    }

    @Override
    public List<SysTenantSubFunction> queryBindSubFunctions(String tenantId, String menuId) {
        LambdaQueryWrapper sysTenantMenuWrapper = Wrappers.lambdaQuery();
        sysTenantMenuWrapper.eq(SysTenantSubFunction::getTenantid, (Object)tenantId);
        sysTenantMenuWrapper.eq(SysTenantSubFunction::getMenuid, (Object)menuId);
        List sysTenantSubFuncitons = this.list((Wrapper)sysTenantMenuWrapper);
        if (sysTenantSubFuncitons.size() == 0) {
            return sysTenantSubFuncitons;
        }
        LambdaQueryWrapper menuWrapper = Wrappers.lambdaQuery();
        menuWrapper.in(SysSubFunction::getPid, (Collection)sysTenantSubFuncitons.stream().map(f -> f.getSubfunctionid()).collect(Collectors.toList()));
        List pIds = this.sysSubFunctionMapper.selectList((Wrapper)menuWrapper).stream().map(f -> f.getPid()).collect(Collectors.toList());
        sysTenantSubFuncitons.removeIf(f -> pIds.contains(f.getSubfunctionid()));
        return sysTenantSubFuncitons;
    }
}

