/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.login.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.geoway.jckj.base.support.QrCodeUtils;
import com.geoway.jckj.base.support.RedisUtil;
import com.geoway.jckj.biz.config.SsoConfig;
import com.geoway.jckj.biz.dto.QrLoginDTO;
import com.geoway.jckj.biz.service.login.IQrLoginService;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import java.util.Arrays;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QrLoginServiceImpl
implements IQrLoginService {
    private static final Logger log = LoggerFactory.getLogger(QrLoginServiceImpl.class);
    @Autowired
    SsoConfig ssoConfig;
    @Autowired
    private RedisUtil redisUtil;
    private static final String REDIS_QR_PREFIX = "QR_";

    @Override
    public QrLoginDTO generateQrCode() throws Exception {
        QrLoginDTO map = new QrLoginDTO();
        JSONObject qrCOntent = new JSONObject();
        try {
            String uidKey = REDIS_QR_PREFIX + UUID.randomUUID().toString();
            int timeout = this.ssoConfig.getQrTimeout();
            this.redisUtil.set(uidKey, (Object)"ready", (long)timeout);
            qrCOntent.put("key", (Object)uidKey);
            qrCOntent.put("expires", (Object)timeout);
            qrCOntent.put("timestamp", (Object)System.currentTimeMillis());
            String baseQr = QrCodeUtils.getBase64QRCode((String)qrCOntent.toJSONString());
            map.setQr(baseQr);
            map.setKey(uidKey);
            map.setTimestamp(System.currentTimeMillis());
            map.setExpires(timeout);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\u751f\u6210\u767b\u5f55\u4e8c\u7ef4\u7801\u5931\u8d25!");
        }
        return map;
    }

    @Override
    public SsoUser getLoginInfo(String key) throws Exception {
        String accessToken = (String)this.redisUtil.get(key);
        if (ObjectUtil.contains(Arrays.asList("ready", "scanned", "confirm", "cancel", "invalid"), (Object)accessToken)) {
            return null;
        }
        if (StrUtil.isNotEmpty((CharSequence)accessToken)) {
            SsoUser user = CommonLoginUserUtil.getUser((String)accessToken);
            user.setToken(accessToken);
            this.redisUtil.del(new String[]{key});
            return user;
        }
        return null;
    }

    @Override
    public Boolean autoLogin(String accessToken, String key, String state) {
        if (this.redisUtil.hasKey(key)) {
            if (ObjectUtil.equal((Object)"confirm", (Object)state)) {
                SsoUser user = CommonLoginUserUtil.getUser((String)accessToken);
                if (user != null) {
                    this.redisUtil.set(key, (Object)accessToken);
                    return true;
                }
            } else {
                String status;
                if (ObjectUtil.equal((Object)"cancel", (Object)state)) {
                    String status2 = (String)this.redisUtil.get(key);
                    this.redisUtil.del(new String[]{key});
                    return ObjectUtil.equal((Object)status2, (Object)"scanned");
                }
                if (ObjectUtil.equal((Object)"scanned", (Object)state) && ObjectUtil.equal((Object)(status = (String)this.redisUtil.get(key)), (Object)"ready")) {
                    this.redisUtil.set(key, (Object)state, (long)this.ssoConfig.getQrTimeout());
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String getQrStatus(String key) {
        if (this.redisUtil.hasKey(key)) {
            SsoUser user;
            String token = (String)this.redisUtil.get(key);
            if (!ObjectUtil.contains(Arrays.asList("ready", "scanned", "confirm", "cancel", "invalid"), (Object)token) && ObjectUtil.isEmpty((Object)(user = CommonLoginUserUtil.getUser((String)token)))) {
                return "invalid";
            }
            return token;
        }
        return "invalid";
    }
}

