/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.util;

import cn.hutool.core.util.StrUtil;
import com.geoway.jckj.base.support.spring.SpringUtils;
import com.geoway.jckj.biz.entity.SysOrganization;
import com.geoway.jckj.biz.entity.SysRegion;
import com.geoway.jckj.biz.entity.SysRole;
import com.geoway.jckj.biz.entity.SysTenant;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.service.dev.base.IUserService;
import com.geoway.jckj.biz.service.dev.unity.IUnityOrganizationService;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserService;
import com.geoway.jckj.biz.service.sys.SysRegionService;
import com.geoway.jckj.biz.service.sys.SysRoleService;
import com.geoway.jckj.biz.service.sys.SysTenantService;
import com.geoway.jckj.biz.service.sys.SysUserCatalogService;
import com.geoway.sso.client.enums.RoleLevelEnum;
import com.geoway.sso.client.rpc.SsoUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.core.env.Environment;

public class SysUserUtil {
    public static final String USE_ORGAN_TENANT = "sso.use-org-tenant";

    public static void wrapperUsers(List<SysUser> users) {
        SysUserUtil.wrapperUserRolesNames(users);
        SysUserUtil.wrapperUserOrgsNames(users);
        SysUserUtil.wrapperUserCatalogs(users);
        SysUserUtil.wrapperUserRegions(users);
    }

    public static void wrapperUserRolesNames(List<SysUser> users) {
        SysRoleService sysRoleService = (SysRoleService)SpringUtils.getBean(SysRoleService.class);
        for (SysUser user : users) {
            if (user == null) continue;
            List<SysRole> roles = sysRoleService.queryUserRoles(user.getId());
            List<String> roleAllNames = roles.stream().map(x -> x.getName()).collect(Collectors.toList());
            user.setRoles(roles);
            user.setRoleNames(roleAllNames);
        }
    }

    public static void wrapperUserOrgsNames(List<SysUser> users) {
        IUnityOrganizationService organizationService = (IUnityOrganizationService)SpringUtils.getBean(IUnityOrganizationService.class);
        for (SysUser user : users) {
            if (user == null) continue;
            List<SysOrganization> organizations = organizationService.queryUserOrgs(user.getId());
            ArrayList<String> organizationNames = new ArrayList<String>();
            for (SysOrganization sysOrganization : organizations) {
                String allName = StrUtil.join((CharSequence)"/", (Iterable)organizationService.queryAllParentOrg(sysOrganization.getId()).stream().map(f -> f.getName()).collect(Collectors.toList()));
                organizationNames.add(allName);
            }
            user.setOrganizations(organizations);
            user.setOrgNames(organizationNames);
        }
    }

    public static void wrapperUserCatalogs(List<SysUser> users) {
        SysUserCatalogService userCatalogService = (SysUserCatalogService)SpringUtils.getBean(SysUserCatalogService.class);
        for (SysUser user : users) {
            if (user == null) continue;
            user.setCatalog(userCatalogService.getUserCatalog(user.getId()));
        }
    }

    public static void wrapperUserTenants(List<SysUser> users) {
        SysTenantService userTenantService = (SysTenantService)SpringUtils.getBean(SysTenantService.class);
        for (SysUser user : users) {
            if (user == null) continue;
            user.setTenants(userTenantService.queryByUserId(user.getId()));
        }
    }

    public static void wrapperUserRegions(List<SysUser> users) {
        SysRegionService userRegionService = (SysRegionService)SpringUtils.getBean(SysRegionService.class);
        for (SysUser user : users) {
            if (user == null) continue;
            user.setRegions(userRegionService.queryUserRegions(user.getId()));
        }
    }

    public static SsoUser convertToSsoUser(SysUser user) {
        SsoUser ssoUser = new SsoUser();
        SysUserUtil.wrapperUsers(Collections.singletonList(user));
        Environment environment = (Environment)SpringUtils.getBean(Environment.class);
        SysRegionService sysRegionService = (SysRegionService)SpringUtils.getBean(SysRegionService.class);
        SysTenantService sysTenantService = (SysTenantService)SpringUtils.getBean(SysTenantService.class);
        SysRoleService sysRoleService = (SysRoleService)SpringUtils.getBean(SysRoleService.class);
        List<SysRegion> regions = sysRegionService.queryUserRegions(user.getId());
        String regionCode = regions.stream().map(i -> i.getCode()).collect(Collectors.joining(","));
        String regionName = regions.stream().map(i -> i.getName()).collect(Collectors.joining(","));
        boolean flag = (Boolean)environment.getProperty(USE_ORGAN_TENANT, Boolean.class, (Object)false);
        if (user.getCatalog().equals(RoleLevelEnum.tenantAdmin.getValue()) || flag) {
            List<SysTenant> sysTenants = sysTenantService.queryByUserId(user.getId());
            String tenant = String.join((CharSequence)",", sysTenants.stream().map(SysTenant::getId).collect(Collectors.toSet()));
            ssoUser.setTenantIds(tenant);
        }
        ssoUser.setRoldIds(sysRoleService.queryUserRoles(user.getId()).stream().map(f -> f.getId()).collect(Collectors.joining(",")));
        ssoUser.setId(user.getId());
        ssoUser.setUserid(user.getId());
        ssoUser.setUserName(user.getAname());
        ssoUser.setLoginName(user.getName());
        ssoUser.setRegionCode(regionCode);
        ssoUser.setRegionName(regionName);
        ssoUser.setUserCatalog(user.getCatalog());
        ssoUser.setSource(user.getSource());
        ssoUser.setAddress(user.getAddress());
        return ssoUser;
    }

    public static SysUser getGuestUser() {
        IUnityUserService unityUserService = (IUnityUserService)SpringUtils.getBean(IUnityUserService.class);
        SysUser sysUser = ((IUserService)unityUserService.getLocalService()).query("guest");
        sysUser.setCatalog(RoleLevelEnum.guest.getValue());
        return sysUser;
    }
}

