/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.util;

import cn.hutool.core.util.StrUtil;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.StringUtils;
import com.geoway.jckj.base.support.spring.SpringUtils;
import com.geoway.jckj.biz.entity.SysOrganization;
import com.geoway.jckj.biz.entity.SysRegion;
import com.geoway.jckj.biz.entity.SysRole;
import com.geoway.jckj.biz.entity.SysTenant;
import com.geoway.jckj.biz.service.dev.unity.IUnityOrganizationService;
import com.geoway.jckj.biz.service.sys.SysRegionService;
import com.geoway.jckj.biz.service.sys.SysRoleService;
import com.geoway.jckj.biz.service.sys.SysTenantService;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.web.context.support.ServletRequestHandledEvent;

@Component
public class TenantUtil
implements ApplicationListener<ServletRequestHandledEvent> {
    private static ThreadLocal<SysTenant> threadLocalTenant = new ThreadLocal();
    private static ThreadLocal<List<String>> threadLocalRegionIds = new ThreadLocal();
    private static ThreadLocal<List<String>> threadLocalOrgIds = new ThreadLocal();
    private static ThreadLocal<List<String>> threadLocalRoleIds = new ThreadLocal();

    public static SysTenant getTenant() {
        if (threadLocalTenant.get() != null) {
            return threadLocalTenant.get();
        }
        SysTenantService sysTenantService = (SysTenantService)SpringUtils.getBean(SysTenantService.class);
        String tenantId = TenantUtil.getTenantId();
        SysTenant sysTenant = null;
        if (tenantId.equals("0")) {
            sysTenant = new SysTenant();
            sysTenant.setId("0");
            sysTenant.setKey("0");
        } else {
            sysTenant = (SysTenant)sysTenantService.getById((Serializable)((Object)tenantId));
            if (sysTenant == null) {
                throw new ServiceException("\u672a\u83b7\u53d6\u5230\u79df\u6237\u4fe1\u606f");
            }
        }
        threadLocalTenant.set(sysTenant);
        return sysTenant;
    }

    public static boolean isTenantAdmin() {
        SsoUser ssoUser = CommonLoginUserUtil.getUser();
        if (ssoUser == null) {
            return false;
        }
        if (!ssoUser.getUserCatalog().equals(2)) {
            return false;
        }
        String tenantId = TenantUtil.getTenantId();
        if (StrUtil.isEmpty((CharSequence)tenantId)) {
            return false;
        }
        if (StrUtil.isEmpty((CharSequence)ssoUser.getTenantIds())) {
            return false;
        }
        String[] tenants = ssoUser.getTenantIds().split(",");
        return Arrays.stream(tenants).anyMatch(f -> f.equals(tenantId));
    }

    public static String getTenantId() {
        if (threadLocalTenant.get() != null) {
            return threadLocalTenant.get().getId();
        }
        String tenantId = CommonLoginUserUtil.getTenantID();
        if (StringUtils.isNotEmpty((String)tenantId) && !tenantId.equals("0")) {
            return tenantId;
        }
        String tenantKey = CommonLoginUserUtil.getTenantKey();
        SysTenantService sysTenantService = (SysTenantService)SpringUtils.getBean(SysTenantService.class);
        if (StringUtils.isNotEmpty((String)tenantKey)) {
            if ("0".equals(tenantKey)) {
                return "0";
            }
            SysTenant sysTenant = sysTenantService.queryByKey(tenantKey);
            if (sysTenant == null) {
                throw new ServiceException("\u672a\u83b7\u53d6\u5230\u79df\u6237\u4fe1\u606f");
            }
            threadLocalTenant.set(sysTenant);
            return sysTenant.getId();
        }
        return "0";
    }

    public static boolean isSuperTenant() {
        String tenantId = TenantUtil.getTenantId();
        return tenantId.equals("0");
    }

    public static List<String> getTenantOrgIds() {
        if (threadLocalOrgIds.get() != null) {
            return threadLocalOrgIds.get();
        }
        IUnityOrganizationService organizationService = (IUnityOrganizationService)SpringUtils.getBean(IUnityOrganizationService.class);
        SysTenant sysTenant = TenantUtil.getTenant();
        if (sysTenant.getId().equals("0")) {
            return new ArrayList<String>();
        }
        ArrayList<String> orgs = new ArrayList<String>();
        List manageOrgs = sysTenant.getOrganizations().stream().map(SysOrganization::getId).collect(Collectors.toList());
        for (String orgId : manageOrgs) {
            orgs.addAll(organizationService.queryAllChildOrg(orgId).stream().map(SysOrganization::getId).collect(Collectors.toList()));
        }
        threadLocalOrgIds.set(orgs);
        return orgs;
    }

    public static List<String> getTenantRegionIds() {
        if (threadLocalRegionIds.get() != null) {
            return threadLocalRegionIds.get();
        }
        SysRegionService sysRegionService = (SysRegionService)SpringUtils.getBean(SysRegionService.class);
        SysTenant sysTenant = TenantUtil.getTenant();
        if (sysTenant.getId().equals("0")) {
            return new ArrayList<String>();
        }
        ArrayList<String> regions = new ArrayList<String>();
        List manageRegions = sysTenant.getRegions().stream().map(SysRegion::getId).collect(Collectors.toList());
        for (String regionId : manageRegions) {
            regions.addAll(sysRegionService.queryRegionListById(regionId).stream().map(SysRegion::getId).collect(Collectors.toList()));
        }
        threadLocalRegionIds.set(regions);
        return regions;
    }

    public static List<String> getTeantRoleIds() {
        if (threadLocalRoleIds.get() != null) {
            return threadLocalRoleIds.get();
        }
        SysRoleService sysRoleService = (SysRoleService)SpringUtils.getBean(SysRoleService.class);
        List<SysRole> roles = sysRoleService.queryList("");
        List<String> roleIds = roles.stream().map(f -> f.getId()).collect(Collectors.toList());
        threadLocalRoleIds.set(roleIds);
        return roleIds;
    }

    public void onApplicationEvent(ServletRequestHandledEvent event) {
        threadLocalTenant.set(null);
        threadLocalRegionIds.set(null);
        threadLocalOrgIds.set(null);
        threadLocalRoleIds.set(null);
    }
}

