/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.api.controller;

import com.geoway.sso.client.client.LoginClient;
import com.geoway.sso.client.client.QrLoginClient;
import com.geoway.sso.client.client.SsoClient;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.RpcImgCaptchaDTO;
import com.geoway.sso.client.rpc.RpcQrLoginDTO;
import com.geoway.sso.client.rpc.RpcSmsCaptchaDTO;
import com.geoway.sso.client.rpc.SsoUser;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jckj/client/login"})
public class ClientLoginController {
    @Autowired
    private SsoClient ssoClient;
    @Autowired
    private LoginClient loginClient;
    @Autowired
    private QrLoginClient qrLoginClient;

    @RequestMapping(value={"/captchaIMG"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Result<RpcImgCaptchaDTO> captchaIMG(HttpServletRequest request) {
        return Result.createSuccess((Object)this.loginClient.getImgCaptcha());
    }

    @RequestMapping(value={"/loginByPassword"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Result<RpcAccessToken> login(HttpServletRequest request, @RequestParam(value="username") String username, @RequestParam(value="password") String password, @RequestParam(value="code") String code, @RequestParam(value="uid") String uid) {
        return Result.createSuccess((Object)this.ssoClient.getAccessToken(username, password, uid, code));
    }

    @RequestMapping(value={"/getSmsCode"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Result<RpcSmsCaptchaDTO> getSmsCode(HttpServletRequest request, String phoneNumber, String checkUser, String captchaVerifyParam, String sceneId) {
        return Result.createSuccess((Object)this.loginClient.getSmsCode(phoneNumber, checkUser, captchaVerifyParam, sceneId));
    }

    @RequestMapping(value={"/loginBySms"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Result<RpcAccessToken> loginBySms(HttpServletRequest request, @RequestParam(value="phoneNumber") String phoneNumber, @RequestParam(value="code") String code, @RequestParam(value="uid") String uid, @RequestParam(value="source", required=false) String source) {
        return Result.createSuccess((Object)this.ssoClient.getAccessTokenBySms(phoneNumber, uid, code));
    }

    @RequestMapping(value={"/getQrCode"}, method={RequestMethod.GET})
    public Result<RpcQrLoginDTO> getQrCode(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return Result.createSuccess((Object)this.qrLoginClient.generateQrCode());
    }

    @RequestMapping(value={"/checkQrCode"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public Result<SsoUser> checkQrCode(String key) throws Exception {
        return Result.createSuccess((Object)this.qrLoginClient.getLoginInfo(key));
    }

    @RequestMapping(value={"/getQrStatus"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public Result<String> getQrStatus(String key) throws Exception {
        return Result.createSuccess((Object)this.qrLoginClient.getQrStatus(key));
    }

    @RequestMapping(value={"/refreshQrLogin"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public Result<RpcAccessToken> refreshQrLogin(String token) throws Exception {
        return Result.createSuccess((Object)this.qrLoginClient.refreshQrLogin(token));
    }

    @RequestMapping(value={"/loginByQr"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public Result<Void> loginByQr(String token, String key, String state) {
        if (this.qrLoginClient.autoLogin(token, key, state).booleanValue()) {
            return Result.createSuccess();
        }
        return Result.createError((String)"\u79fb\u52a8\u7aef\u767b\u5f55\u5931\u6548!");
    }

    @RequestMapping(value={"/loginByCa"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Result<RpcAccessToken> loginByCa(HttpServletRequest request, @RequestParam(value="usercert") String usercert, @RequestParam(value="oauthname") String oauthname) {
        return Result.createSuccess((Object)this.ssoClient.getAccessTokenByCa(usercert, oauthname));
    }

    @RequestMapping(value={"/loginByOne"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Result<RpcAccessToken> loginByOne(HttpServletRequest request, @RequestParam(value="processId") String processId, @RequestParam(value="token") String token, @RequestParam(value="authCode", required=false) String authCode) {
        return Result.createSuccess((Object)this.ssoClient.getAccessTokenByOne(processId, token, authCode));
    }

    @RequestMapping(value={"/loginOut"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Result<Boolean> loginOut(HttpServletRequest request) {
        return Result.createSuccess((Object)this.loginClient.loginOut());
    }
}

