package com.geoway.sso.client.client.impl;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.FIFOCache;
import com.alibaba.fastjson.JSON;
import com.geoway.sso.client.client.RouteClient;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import com.geoway.sso.client.util.HttpServletUtil;
import com.geoway.sso.client.util.RouteUtil;
import com.geoway.sso.client.rpc.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Objects;

import static com.geoway.sso.client.constant.UisConstant.REDIS_TOKEN_USERROUTE;

/**
 * @author 连世忠
 * @ClassName RouteClient
 * @Description TODO
 * @date 2025/4/17 15:22
 * @Version 1.0
 */
@Component
public class RouteClientImpl extends Client implements RouteClient {
    private static FIFOCache<String,String> fifoCache;
    @Autowired
    public RouteClientImpl(){
        fifoCache= CacheUtil.newFIFOCache(100000000,60*1000);
    }
    /**
     * 当前用户是否允许访问该路由
     * @return
     */
    @Override
    public boolean isAllowAccess(){
       return isAllowAccess(HttpServletUtil.getRequest());
    }

    /**
     * 当前用户是否允许访问该路由
     * @param request
     * @return
     */
    @Override
    public boolean isAllowAccess(HttpServletRequest request){
        String token= CommonLoginUserUtil.getToken();
        List<String> serverRoutes;
        String  redisKey=REDIS_TOKEN_USERROUTE+token;
        if(fifoCache.containsKey(redisKey)){
            serverRoutes = JSON.parseArray(fifoCache.get(redisKey),String.class);
        }else{
            serverRoutes =getServerRoutes();
            String serverRoutesStr = JSON.toJSONString(serverRoutes);
            fifoCache.put(redisKey, serverRoutesStr, 60*1000);
        }
        String servletPath = request.getServletPath();
        String[] servletPathArr = servletPath.split("/");
        for(String serverRoute : serverRoutes){
            if(matchRoute(servletPathArr,serverRoute)){
                return true;
            }
        }
        return false;
    }

    private boolean matchRoute(String[] servletPathArr,String serverRoute){
        String[] serverRouteArr = serverRoute.split("/");
        for(int i = 0;i < servletPathArr.length;i++){
            if(serverRouteArr.length < i + 1){
                return false;
            }
            if(serverRouteArr[i].contains("*")){
                return true;
            }
            if(!Objects.equals(servletPathArr[i],serverRouteArr[i])){
                return false;
            }
        }
        return true;
    }
    /**
      * 获取当前用户能访问的路由地址
     * @return
    */
    @Override
    public List<String> getServerRoutes(){
        Result<List<String>> result= RouteUtil.getServerRoutes(provider.getRpcClientInfo().getServerUrl(),getHeader());
        if(result==null){
            return null;
        }
        if(result.isSuccess()){
            return result.getData();
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }

}
