package com.geoway.sso.client.rpc;

import com.geoway.sso.client.constant.Oauth2Constant;
import com.geoway.sso.client.constant.SsoConstant;

import java.beans.Transient;
import java.io.Serializable;

/**
 * @author ALMJ
 * @desc 返回结果
 */
public class Result<T> implements Serializable {
    private static final long serialVersionUID = 1956544564021082972L;
    /**
     * 未登录状态
     */
    public static final int NO_LOGIN = 2100;

    /**
     * 重新修改密码
     */
    public static final int STATUS_RESETPASSWORD = 3003;

    /**
     * 成功
     */
    @SuppressWarnings("rawtypes")
    public static final Result SUCCESS = createSuccess();

    /**
     * 结果体
     */
    protected T data;

    /**
     * 状态码
     */
    protected int code;


    /**
     * 状态文字
     */
    protected String status;

    /**
     * 信息
     */
    protected String message;

    private Result() {
        super();
    }

    public static <T> Result<T> create() {
        return new Result<>();
    }

    public static <T> Result<T> create(int code) {
        Result<T> r = create();
        r.setStatus(Oauth2Constant.STATUS_OK);
        if (code == SsoConstant.NO_LOGIN) {
            r.setStatus(Oauth2Constant.STATUS_FAILURE);
        }
        r.setCode(code);
        return r;
    }

    public static <T> Result<T> create(int code, String message) {
        Result<T> r = create(code);
        r.setStatus(Oauth2Constant.STATUS_OK);
        if (code == SsoConstant.NO_LOGIN) {
            r.setStatus(Oauth2Constant.STATUS_FAILURE);
        }
        r.setMessage(message);
        return r;
    }

    public static <T> Result<T> createLoginRedirect(T data) {
        Result<T> r = create(NO_LOGIN);
        r.setStatus(Oauth2Constant.STATUS_OK);
        r.setData(data);
        return r;
    }

    public static <T> Result<T> createNoLogin() {
        Result<T> r = create(NO_LOGIN);
        return r;
    }
    public static <T> Result<T> createLoginRedirect(T data, String message) {
        Result<T> r = create(NO_LOGIN);
        r.setStatus(Oauth2Constant.STATUS_OK);
        r.setData(data);
        r.setMessage(message);
        return r;
    }

    @SuppressWarnings("unchecked")
    public static final <T> Result<T> success() {
        return SUCCESS;
    }

    public static <T> Result<T> createSuccess() {
        return create(Oauth2Constant.SUCCESS_CODE);
    }

    public static <T> Result<T> createSuccess(T data) {
        Result<T> r = createSuccess();
        r.setData(data);
        return r;
    }

    public static <T> Result<T> createError(T data) {
        Result<T> r = create(Oauth2Constant.ERROR_CODE);
        r.setStatus(Oauth2Constant.STATUS_FAILURE);
        r.setData(data);
        return r;
    }

    public static <T> Result<T> createSuccess(T data, String message) {
        Result<T> r = createSuccess(data);
        r.setMessage(message);
        return r;
    }

    public static <T> Result<T> createError(String message) {

        Result<T> r= create(Oauth2Constant.ERROR_CODE, message);
        r.setStatus(Oauth2Constant.STATUS_FAILURE);
        return r;
    }

    public static <T> Result<T> createError(T data, String message) {
        Result<T> r = createError(data);
        r.setMessage(message);
        return r;
    }

    public T getData() {
        return data;
    }

    public Result<T> setData(T data) {
        this.data = data;
        return this;
    }

    public int getCode() {
        return code;
    }

    public Result<T> setCode(int code) {
        this.code = code;
        return this;
    }

    public String getMessage() {
        return message;
    }

    public Result<T> setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Transient
    public boolean isSuccess() {
        return Oauth2Constant.SUCCESS_CODE == code||200==code||status.equalsIgnoreCase(Oauth2Constant.STATUS_OK);
    }
}
