package com.geoway.sso.client.rpc;


import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;

/**
 * 系统
 * @author: wujing
 * @Date: 2021/11/15
 */
@Data
@NoArgsConstructor
public class RpcSysSystem extends RpcSaasEntity {

    /**
     * 系统id
     */
    private String id;
    /**
     * 系统名称
     */

    private String name;

    /**
     * 关键字
     */

    private String key;

    /**
     * 版本
     */

    private String version;

    /**
     * 系统图标
     */

    private String icon;

    /**
     * 所属公司
     */

    private String company;

    /**
     * 地址
     */

    private String url;

    /**
     * 后端地址
     */

    private String backendUrl;

    /**
     * 系统类型（1.注册的应用2.构建的系统)
     */

    private Integer type;

    /**
     * 创建时间
     */

    private Date createtime;

    /**
     * 主题id
     */

    private String themeid;

    /**
     * 样式
     */

    private String style;

    /**
     * 是否内置应用（0.否 1.是）
     */

    private Integer inner;

    /**
     * 分組id
     */

    private String groupid;

    /**
     *logo id
     */

    private String logoid;

    /**
     *背景 id
     */

    private String bgid;



    private String params;

    /**
     * 系统状态
     */

    private Integer state=1;


    /**
     * 系统地址是否可访问（0不可访问，1可访问）
     */

    private int access =1;

    private String bz;

    private List<RpcSysMenu> sysMenu;

    private List<RpcSysMenu> uCenterMenu;

    private int spaceStatus =-1;

    /**
     * 展示名称：租户自己创建的显示
     */

    private String displayName;



}
