package com.geoway.sso.client.util;

import com.geoway.sso.client.service.IOauth2Utils;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author ALMJ
 * @desc Oauth2辅助类
 */
@Component
public class Oauth2Utils {

    public static IOauth2Utils Util;
    @Autowired
    public Oauth2Utils(IOauth2Utils iOauth2Utils){
        Oauth2Utils.Util=iOauth2Utils;
    }


    /**
     * 获取accessToken（密码模式，app通过此方式由客户端代理转发http请求到服务端获取accessToken）
     *
     * @param serverUrl
     * @param appId
     * @param appSecret
     * @param username
     * @param password
     * @return
     */
    public static Result<RpcAccessToken> getAccessToken(String serverUrl, String appId, String appSecret, String username,
                                                        String password) {
        return Util.getAccessToken(serverUrl,appId,appSecret,username,password);
    }
    /**
     * 获取accessToken（授权码模式）
     *
     * @param serverUrl
     * @param appId
     * @param appSecret
     * @param code
     * @return
     */
    public static Result<RpcAccessToken> getAccessToken(String serverUrl, String appId, String appSecret, String code) {
        return Util.getAccessTokenByCode(serverUrl,appId,appSecret,code);
    }
    /**
     * 获取accessToken（短信验证码）
     * @param serverUrl
     * @param appId
     * @param appSecret
     * @param tel
     * @param uuid
     * @param code
     * @return
     */
    public static Result<RpcAccessToken> getAccessTokenBySms(String serverUrl, String appId, String appSecret, String tel,
                                                             String uuid, String code) {
        return Util.getAccessTokenBySms(serverUrl,appId,appSecret,tel,uuid,code);
    }

    /**
     * 一键登入
     * @param serverUrl
     * @param appId
     * @param appSecret
     * @param processId
     * @param token
     * @param authCode
     * @return
     */
    public static Result<RpcAccessToken> getAccessTokenByOne(String serverUrl,String appId, String appSecret,String processId, String token, String authCode) {
        return Util.getAccessTokenByOne(serverUrl,appId,appSecret,processId,token,authCode);
    }

    /**
     * CA登入
     * @param serverUrl
     * @param appId
     * @param appSecret
     * @param caUserCert
     * @param caOauthName
     * @return
     */
    public static Result<RpcAccessToken> getAccessTokenByCa(String serverUrl, String appId, String appSecret,String caUserCert, String caOauthName) {
        return Util.getAccessTokenByCa(serverUrl,appId,appSecret,caUserCert,caOauthName);
    }


    /**
     * 刷新accessToken
     *
     * @param serverUrl    单点登录服务地址
     * @param appId        应用授权id
     * @param refreshToken 刷新新令牌
     * @return
     */
    public static Result<RpcAccessToken> refreshToken(String serverUrl, String appId, String refreshToken) {
       return Util.refreshToken(serverUrl,appId,refreshToken);
    }

    /**
     * 查询令牌对应的用户登录信息
     *
     * @param serverUrl   单点登录服务地址
     * @param accessToken 当前用户访问令牌
     * @return
     */
    public static Result<RpcAccessToken> queryAccessToken(String serverUrl, String accessToken) {
        return Util.queryAccessToken(serverUrl,accessToken);

    }

    /**
     * 撤销访问凭证(单点退出)
     *
     * @param serverUrl   单点登录服务地址
     * @param accessToken 当前用户令牌
     * @return
     */
    public static Result<RpcAccessToken> revokeAccessToken(String serverUrl, String accessToken) {
        return Util.revokeAccessToken(serverUrl,accessToken);
    }


    /**
     * 撤销访问凭证(单点退出)
     *
     * @param serverUrl   单点登录服务地址
     * @param accessToken 当前用户令牌
     * @return
     */
    public static Result<String> getAccessCode(String serverUrl, String appId, String appSecret,String accessToken) {
        return Util.getAccessCode(serverUrl,appId,appSecret,accessToken);
    }

}