/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.sso.client.filter.ParamFilter;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CookieUtils;
import com.geoway.sso.client.util.HttpServletUtil;
import com.geoway.sso.client.util.Oauth2Utils;
import com.geoway.sso.client.util.SessionUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CommonLoginUserUtil
extends ParamFilter {
    private static String serverUrl;

    @Value(value="${sso.server.url:}")
    public void setAddress(String url) {
        serverUrl = url;
    }

    public static String getToken() {
        HttpServletRequest request = HttpServletUtil.getRequest();
        if (request == null) {
            return "";
        }
        String parameterToken = request.getParameter("token");
        if (StrUtil.isNotBlank((CharSequence)parameterToken)) {
            return parameterToken;
        }
        parameterToken = request.getParameter("access_token");
        if (StrUtil.isNotBlank((CharSequence)parameterToken)) {
            return parameterToken;
        }
        String authToken = request.getHeader("access_token");
        if (StrUtil.isNotBlank((CharSequence)authToken)) {
            return authToken;
        }
        String sessionCookieName = CookieUtils.getCookie(request, "ns-design-token");
        if (StrUtil.isNotBlank((CharSequence)sessionCookieName)) {
            return sessionCookieName;
        }
        return null;
    }

    public static String getTenantKey() {
        HttpServletRequest request = HttpServletUtil.getRequest();
        String headerKey = request.getHeader("tenantKey");
        if (StrUtil.isNotBlank((CharSequence)headerKey)) {
            return headerKey;
        }
        String parameterTenant = request.getParameter("tenantKey");
        if (StrUtil.isNotBlank((CharSequence)parameterTenant)) {
            return parameterTenant;
        }
        return null;
    }

    public static String getTenantID() {
        HttpServletRequest request = HttpServletUtil.getRequest();
        if (request == null) {
            return null;
        }
        String authTenant = request.getHeader("tenantId");
        if (StrUtil.isNotBlank((CharSequence)authTenant)) {
            return authTenant;
        }
        return null;
    }

    public static SsoUser getUser() {
        return CommonLoginUserUtil.getUser(CommonLoginUserUtil.getToken());
    }

    public static String getQueryUserId() {
        HttpServletRequest request = HttpServletUtil.getRequest();
        String userId = request.getParameter("userId");
        if (StrUtil.isNotBlank((CharSequence)userId)) {
            return userId;
        }
        return CommonLoginUserUtil.getUserId();
    }

    public static SsoUser getUser(String accessToken) {
        HttpServletRequest request = HttpServletUtil.getRequest();
        SsoUser user = SessionUtils.getUser(request, accessToken);
        if (ObjectUtil.isNotNull((Object)user)) {
            return user;
        }
        if (!StrUtil.isAllNotEmpty((CharSequence[])new CharSequence[]{accessToken})) {
            return null;
        }
        Result<RpcAccessToken> result = Oauth2Utils.queryAccessToken(serverUrl, accessToken);
        if (result.isSuccess() && ObjectUtil.isNotNull((Object)result.getData())) {
            return result.getData().getUser();
        }
        return null;
    }

    public static String getUserId() {
        SsoUser ssoUser = CommonLoginUserUtil.getUser();
        return ssoUser != null ? ssoUser.getUserid() : "";
    }
}

