package com.geoway.sso.client.client.impl;

import com.geoway.sso.client.client.LoginClient;
import com.geoway.sso.client.client.MenuClient;
import com.geoway.sso.client.client.UserClient;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcSysSubFunction;
import com.geoway.sso.client.rpc.RpcSysUser;
import com.geoway.sso.client.rpc.RpcSystemInfoDTO;
import com.geoway.sso.client.util.UisUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author 连世忠
 * @ClassName MenuClientImpl
 * @Description TODO
 * @date 2025/8/22 10:47
 * @Version 1.0
 */
@Component
public class MenuClientImpl extends Client implements MenuClient {
    @Autowired
    UserClient userClient;

    @Override
    public List<RpcSysSubFunction> getSubFunctions(String menuId) {
        RpcSysUser rpcSysUser= userClient.getCurrentUserInfo();
        if(rpcSysUser.getRoles()==null){
            return new ArrayList<>();
        }
        String roleIds=rpcSysUser.getRoles().stream().map(f->f.getId()).collect(Collectors.joining(","));
        Result<List<RpcSysSubFunction>> result= UisUtils.querySubFunctionsByMenuId(provider.getRpcClientInfo().getServerUrl(),roleIds,menuId,getHeader());
        if(result==null){
            return null;
        }
        if(result.isSuccess()){
            return result.getData();
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }
}
