package com.geoway.sso.client.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.geoway.sso.client.constant.UisConstant;
import com.geoway.sso.client.rpc.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.geoway.sso.client.rpc.Result.STATUS_RESETPASSWORD;

public class UisUtils {
    private static final Logger logger = LoggerFactory.getLogger(UisUtils.class);

    /**
     * 获取用户信息
     * @param serverUrl
     * @param userId
     * @param headerMap
     * @return
     */

    public static Result<RpcSysUser> getUserInfo(String serverUrl,String userId, Map<String, String> headerMap)  {
        Map<String, String> paramMap = new HashMap<>();
        paramMap.put("id",userId);
        Result<RpcSysUser> result= HttpUtils.getHttp(serverUrl + UisConstant.QUERY_USERDETAIL_URL, paramMap,headerMap,RpcSysUser.class);
        return result;
    }

    /**
     *  获取当前登入用户的用户信息
     * @param serverUrl
     * @param headerMap
     * @return
     */
    public static Result<RpcSysUser> getCurrentUserInfo(String serverUrl, Map<String, String> headerMap)  {
        Map<String, String> paramMap = new HashMap<>();
        Result<RpcSysUser> result= HttpUtils.getHttp(serverUrl + UisConstant.QUERY_CURRENT_USERDETAIL_URL, paramMap,headerMap,RpcSysUser.class);
        return result;
    }


    /**
     *  修改当前用户的基本信息
     * @param serverUrl
     * @return
     */

    public static Result<Void> modifyCurrentUserInfo(String serverUrl, RpcSysUser rpcSysUser, Map<String, String> headerMap) {
        Map<String, String> paramMap=new HashMap<>();
        JSONObject jsonObject=JSONUtil.parseObj(rpcSysUser);
        jsonObject.forEach(f->{
            if(f.getValue()!=null) {
                paramMap.put(f.getKey(),f.getValue().toString());
            }
        });
        Result<Void> result= HttpUtils.postHttp(serverUrl+UisConstant.MODIFY_USER_URL,paramMap,headerMap,null,Void.class);
        return result;
    }

    /**
     * 修改当前用户的密码
     * @param serverUrl
     * @return
     */

    public static Result<String> getCurrentUserRealTel(String serverUrl,Map<String, String> headerMap) {
        Map<String, String> paramMap=new HashMap<>();
        Result<String> result= HttpUtils.getHttp(serverUrl+UisConstant.QUERY_CURRENT_USERTEL_URL,paramMap,headerMap,String.class);
        return result;
    }
    /**
     * 修改当前用户的密码
     * @param serverUrl
     * @return
     */

    public static Result<Void> modifyCurrentUserPassword(String serverUrl, String oldPwd, String newPwd, Map<String, String> headerMap) {
        Map<String, String> paramMap=new HashMap<>();
        paramMap.put("oldPwd",oldPwd);
        paramMap.put("newPwd",newPwd);
        Result<Void> result= HttpUtils.postHttp(serverUrl+UisConstant.CHANGEPWD_USER_URL,paramMap,headerMap,null,Void.class);
        return result;
    }

    /**
     * 获取用户列表
     * @param serverUrl
     * @param filterParam
     * @param userSys
     * @return
     */

    public static Result<List<RpcSysUser>> getUserList(String serverUrl, String filterParam, String userSys,Map<String, String> headerMap) {
        Map<String, String> paramMap = new HashMap<>();
        paramMap.put(UisConstant.FilterParam, filterParam);
        paramMap.put(UisConstant.USER_SYS, userSys);
        Result<List<RpcSysUser>> result= HttpUtils.getHttpList(serverUrl+UisConstant.QUERY_USERLIST_URL,paramMap,headerMap,RpcSysUser.class);
        return result;
    }


    /**
     * 获取在线用户统计数据
     * @param serverUrl
     * @param headerMap
     * @return
     */

    public static Result<RpcUserOnlineStatDTO> getUserOnlineStatInfo(String serverUrl, Map<String, String> headerMap) {
        Map<String, String> paramMap = new HashMap<>();
        Result<RpcUserOnlineStatDTO> result= HttpUtils.getHttp(serverUrl+UisConstant.QUERY_USERONLINE_URL,paramMap,headerMap,RpcUserOnlineStatDTO.class);
        return result;
    }



    /**
     * 校验当前用户是否需要重置密码
     * @param serverUrl
     * @param headerMap
     * @return
     */

    public static Result<Boolean> validSecure(String serverUrl, Map<String, String> headerMap) {
        Map<String, String> paramMap = new HashMap<>();
        Result<Void> result= HttpUtils.getHttp(serverUrl+UisConstant.QUERY_CURRENT_USERDETAIL_URL,paramMap,headerMap,Void.class);
        if(result.getCode()==STATUS_RESETPASSWORD){
            return Result.createSuccess(Boolean.TRUE);
        }else{
            return Result.createSuccess(Boolean.FALSE);
        }
    }

    /**
     * 获取用户体系
     * @param serverUrl
     * @param headerMap
     * @return
     */
    public static Result<List<RpcUserSystem>> getUserSystems(String serverUrl, Map<String, String> headerMap) {
        Map<String, String> paramMap = new HashMap<>();
        Result<List<RpcUserSystem>> result= HttpUtils.getHttpList(serverUrl+UisConstant.QUERY_USERSYSTEMS_URL,paramMap,headerMap,RpcUserSystem.class);
        return result;
    }
    /**
     * 获取机构树
     * @param serverUrl
     * @param
     * @return
     */

    public static Result<List<RpcSysOrganization>> getOrgTree(String serverUrl, Map<String, String> headerMap) {
        Map<String, String> paramMap = new HashMap<>();
        Result<List<RpcSysOrganization>> result= HttpUtils.getHttpList(serverUrl+UisConstant.QUERY_ORGTREE_URL,paramMap,headerMap,RpcSysOrganization.class);
        return result;
    }

    /**
     * 获取机构树
     * @param serverUrl
     * @param
     * @return
     */

    public static Result<RpcSysOrganization> getOrgInfo(String serverUrl,String id,String filterParam, Map<String, String> headerMap) {
        Map<String, String> paramMap = new HashMap<>();
        paramMap.put(UisConstant.ID,id);
        paramMap.put(UisConstant.FilterParam,filterParam);
        Result<RpcSysOrganization> result= HttpUtils.getHttp(serverUrl+UisConstant.QUERY_ORGDETAIL_URL,paramMap,headerMap,RpcSysOrganization.class);
        return result;
    }

    /**
     * 获取下级机构（只查下一级）
     * @param serverUrl
     * @param pid
     * @return
     */

    public static Result<List<RpcSysOrganization>> getChildOrg(String serverUrl, String pid, Map<String, String> headerMap) {
        Map<String, String> paramMap = new HashMap<>();
        if(StrUtil.isBlank(pid)){
            return Result.createSuccess(new ArrayList<>());
        }
        paramMap.put("filterParam","pid_EQ_" + pid);
        Result<List<RpcSysOrganization>> result= HttpUtils.getHttpList(serverUrl+UisConstant.QUERY_ORGLIST_URL,paramMap,headerMap,RpcSysOrganization.class);
        return result;
    }


    /**
     * 获取下级机构（只查下一级）
     * @param serverUrl
     * @param
     * @return
     */

    public static Result<List<RpcSysUser>> getRelUsers(String serverUrl, String id, Map<String, String> headerMap) {
        Map<String, String> paramMap = new HashMap<>();
        paramMap.put("orgId",id);

        Result<List<RpcSysUser>> result= HttpUtils.postHttpList(serverUrl+UisConstant.QUERY_ORGRELUSERS_URL,paramMap,headerMap,null,RpcSysUser.class);
        return result;
    }

    /**
     * 获取角色树列表
     * @param serverUrl
     * @param filterParam
     * @return
     */

    public static Result<List<RpcSysRole>> queryRoleTree(String serverUrl, String filterParam, Map<String, String> headerMap) {

        Map<String, String> paramMap = new HashMap<>();
        paramMap.put(UisConstant.FilterParam, filterParam);
        Result<List<RpcSysRole>> result= HttpUtils.getHttpList(serverUrl+UisConstant.QUERY_ROLETREE_URL,paramMap,headerMap,RpcSysRole.class);
        return result;
    }

    /**
     * 获取用户权限
     * @param serverUrl
     * @param roldIds
     * @return
     */
    //@RequestMapping(value = "/role/permissions", method = {RequestMethod.POST}, produces = {"application/json;charset=UTF-8"})
    //public Result<List<RpcSysPermission>> queryRolePermissions(String serverUrl, String roldIds) {
        //Map<String,String> maps=new HashMap<>();
        //maps.put(UisConstant.RoleIds,roldIds);
        //Result<List<RpcSysPermission>> result = postHttpAccessToken(serverUrl+UisConstant.QUERY_ROLEPERMISSIONS_URL,null,maps);
        //return result;
    //}

    /**
     * 获取角色列表
     * @param serverUrl
     * @param filterParam
     * @return
     */
    //@RequestMapping(value = "/role/list", method = {RequestMethod.GET, RequestMethod.POST}, produces = {"application/json;charset=UTF-8"})
    public static Result<List<RpcSysRole>> queryRoleList(String serverUrl, String filterParam,Map<String, String> headerMap) {
        Map<String, String> paramMap = new HashMap<>();
        paramMap.put(UisConstant.FilterParam, filterParam);
        Result<List<RpcSysRole>> result= HttpUtils.postHttpList(serverUrl+UisConstant.QUERY_ROLELIST_URL,paramMap,headerMap,null,RpcSysRole.class);
        return result;
    }

    /**
     * 获取角色关联用户
     * @param serverUrl
     * @param roleId
     * @return
     */

    public static Result<List<RpcSysUser>> queryRoleUsers(String serverUrl, String roleId, Map<String, String> headerMap) {
        Map<String, String> paramMap = new HashMap<>();
        paramMap.put(UisConstant.RoleId, roleId);
        Result<List<RpcSysUser>> result= HttpUtils.postHttpList(serverUrl+UisConstant.QUERY_ROLEUSER_URL,paramMap,headerMap,null,RpcSysUser.class);
        return result;
    }
    /**
     * 获取角色关联用户
     * @param serverUrl
     * @param
     * @return
     */
    public static Result<RpcPage<RpcSysRole>> queryRolePage(String serverUrl,String filterParam, Integer page, Integer size, Map<String, String> headerMap) {
        Map<String, String> paramMap = new HashMap<>();
        if(page==null){
            page=1;
        }
        if(size==null){
            size=10;
        }
        paramMap.put(UisConstant.FilterParam, filterParam);
        paramMap.put(UisConstant.PageParam, page.toString());
        paramMap.put(UisConstant.SizeParam, size.toString());
        Result<RpcPage<RpcSysRole>> result= HttpUtils.getHttpPage(serverUrl+UisConstant.Query_ROLEPAGE_URL,paramMap,headerMap,RpcSysRole.class);
        return result;
    }
    /**
     * 获取角色关联用户
     * @param serverUrl
     * @param
     * @return
     */
    public static Result<RpcPage<RpcSysTenant>> queryTenantPage(String serverUrl,String filterParam, Integer page, Integer size, Map<String, String> headerMap) {
        Map<String, String> paramMap = new HashMap<>();
        if(page==null){
            page=1;
        }
        if(size==null){
            size=10;
        }
        paramMap.put(UisConstant.FilterParam, filterParam);
        paramMap.put(UisConstant.PageParam, page.toString());
        paramMap.put(UisConstant.SizeParam, size.toString());
        Result<RpcPage<RpcSysTenant>> result= HttpUtils.getHttpPage(serverUrl+UisConstant.Query_TENANTPAGE_URL,paramMap,headerMap,RpcSysTenant.class);
        return result;
    }

    /**
     * 获取角色关联用户
     * @param serverUrl
     * @param
     * @return
     */
    public static Result<RpcSystemInfoDTO> querySystemInfoByKey(String serverUrl,String systemKey, Map<String, String> headerMap) {
        Map<String, String> paramMap = new HashMap<>();

        paramMap.put(UisConstant.SYSTEMKEY, systemKey);
        paramMap.put(UisConstant.KEY, systemKey);
        Result<RpcSystemInfoDTO> result= HttpUtils.getHttp(serverUrl+UisConstant.Query_SYSTEMINFO_URL,paramMap,headerMap,RpcSystemInfoDTO.class);
        return result;
    }

    /**
     * 获取角色关联用户
     * @param serverUrl
     * @param
     * @return
     */
    public static Result<List<RpcSysSubFunction>> querySubFunctionsByMenuId(String serverUrl,String roleId,String menuId, Map<String, String> headerMap) {
        Map<String, String> paramMap = new HashMap<>();
        paramMap.put("menuId", menuId);
        Result<List<RpcSysSubFunction>> result= HttpUtils.getHttpList(serverUrl+UisConstant.QUERY_MENUSUBFUNCTION_URL,paramMap,headerMap,RpcSysSubFunction.class);
        return result;
    }

    /**
     * 获取用户拥有的功能路由列表
     * @param serverUrl
     * @param token
     * @param systemKey
     * @return
     */
    //@RequestMapping(value = "/user/serverRoutes", method = {RequestMethod.GET, RequestMethod.POST}, produces = {"application/json;charset=UTF-8"})
    //public Result<List<String>> queryServerRoutes(String serverUrl, String token, String systemKey) {


       // Map<String, String> paramMap = new HashMap<>();
        //paramMap.put(SsoConstant.PARAM_TOKEN, token);
        //paramMap.put(UisConstant.SystemKey, systemKey);
        //Result<List<String>> result=postHttpAccessToken(serverUrl+UisConstant.QUERY_ServerRoutes_URL,paramMap,null);
       // return result;


    //}






}
