/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.client.impl;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.FIFOCache;
import com.alibaba.fastjson.JSON;
import com.geoway.sso.client.client.RouteClient;
import com.geoway.sso.client.client.impl.Client;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import com.geoway.sso.client.util.HttpServletUtil;
import com.geoway.sso.client.util.RouteUtil;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RouteClientImpl
extends Client
implements RouteClient {
    private static FIFOCache<String, String> fifoCache;

    @Autowired
    public RouteClientImpl() {
        fifoCache = CacheUtil.newFIFOCache((int)100000000, (long)60000L);
    }

    @Override
    public boolean isAllowAccess() {
        return this.isAllowAccess(HttpServletUtil.getRequest());
    }

    @Override
    public boolean isAllowAccess(HttpServletRequest request) {
        List serverRoutes;
        String token = CommonLoginUserUtil.getToken();
        String redisKey = "UserRoute:Routes:" + token;
        if (fifoCache.containsKey((Object)redisKey)) {
            serverRoutes = JSON.parseArray((String)((String)fifoCache.get((Object)redisKey)), String.class);
        } else {
            serverRoutes = this.getServerRoutes();
            String serverRoutesStr = JSON.toJSONString(serverRoutes);
            fifoCache.put((Object)redisKey, (Object)serverRoutesStr, 60000L);
        }
        String servletPath = request.getServletPath();
        String[] servletPathArr = servletPath.split("/");
        for (String serverRoute : serverRoutes) {
            if (!this.matchRoute(servletPathArr, serverRoute)) continue;
            return true;
        }
        return false;
    }

    private boolean matchRoute(String[] servletPathArr, String serverRoute) {
        String[] serverRouteArr = serverRoute.split("/");
        for (int i = 0; i < servletPathArr.length; ++i) {
            if (serverRouteArr.length < i + 1) {
                return false;
            }
            if (serverRouteArr[i].contains("*")) {
                return true;
            }
            if (Objects.equals(servletPathArr[i], serverRouteArr[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<String> getServerRoutes() {
        Result<List<String>> result = RouteUtil.getServerRoutes(this.provider.getRpcClientInfo().getServerUrl(), this.getHeader());
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        }
        throw new RuntimeException(result.getMessage());
    }
}

