/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.util;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcPage;
import com.geoway.sso.client.rpc.RpcSysOrganization;
import com.geoway.sso.client.rpc.RpcSysRole;
import com.geoway.sso.client.rpc.RpcSysSubFunction;
import com.geoway.sso.client.rpc.RpcSysTenant;
import com.geoway.sso.client.rpc.RpcSysUser;
import com.geoway.sso.client.rpc.RpcSystemInfoDTO;
import com.geoway.sso.client.rpc.RpcUserOnlineStatDTO;
import com.geoway.sso.client.rpc.RpcUserSystem;
import com.geoway.sso.client.util.HttpUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UisUtils {
    private static final Logger logger = LoggerFactory.getLogger(UisUtils.class);

    public static Result<RpcSysUser> getUserInfo(String serverUrl, String userId, Map<String, String> headerMap) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("id", userId);
        Result<RpcSysUser> result = HttpUtils.getHttp(serverUrl + "/user/findOne", paramMap, headerMap, RpcSysUser.class);
        return result;
    }

    public static Result<RpcSysUser> getCurrentUserInfo(String serverUrl, Map<String, String> headerMap) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        Result<RpcSysUser> result = HttpUtils.getHttp(serverUrl + "/user/queryUserInfo", paramMap, headerMap, RpcSysUser.class);
        return result;
    }

    public static Result<Void> modifyCurrentUserInfo(String serverUrl, RpcSysUser rpcSysUser, Map<String, String> headerMap) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        JSONObject jsonObject = JSONUtil.parseObj((Object)rpcSysUser);
        jsonObject.forEach(f -> {
            if (f.getValue() != null) {
                paramMap.put((String)f.getKey(), f.getValue().toString());
            }
        });
        Result<Void> result = HttpUtils.postHttp(serverUrl + "/user/update", paramMap, headerMap, null, Void.class);
        return result;
    }

    public static Result<String> getCurrentUserRealTel(String serverUrl, Map<String, String> headerMap) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        Result<String> result = HttpUtils.getHttp(serverUrl + "/user/getCurUserRealTel", paramMap, headerMap, String.class);
        return result;
    }

    public static Result<Void> modifyCurrentUserPassword(String serverUrl, String oldPwd, String newPwd, Map<String, String> headerMap) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("oldPwd", oldPwd);
        paramMap.put("newPwd", newPwd);
        Result<Void> result = HttpUtils.postHttp(serverUrl + "/user/changePwd", paramMap, headerMap, null, Void.class);
        return result;
    }

    public static Result<List<RpcSysUser>> getUserList(String serverUrl, String filterParam, String userSys, Map<String, String> headerMap) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("filterParam", filterParam);
        paramMap.put("userSys", userSys);
        Result<List<RpcSysUser>> result = HttpUtils.getHttpList(serverUrl + "/user/queryList", paramMap, headerMap, RpcSysUser.class);
        return result;
    }

    public static Result<RpcUserOnlineStatDTO> getUserOnlineStatInfo(String serverUrl, Map<String, String> headerMap) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        Result<RpcUserOnlineStatDTO> result = HttpUtils.getHttp(serverUrl + "/user/queryCount", paramMap, headerMap, RpcUserOnlineStatDTO.class);
        return result;
    }

    public static Result<Boolean> validSecure(String serverUrl, Map<String, String> headerMap) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        Result<Void> result = HttpUtils.getHttp(serverUrl + "/user/queryUserInfo", paramMap, headerMap, Void.class);
        if (result.getCode() == 3003) {
            return Result.createSuccess(Boolean.TRUE);
        }
        return Result.createSuccess(Boolean.FALSE);
    }

    public static Result<List<RpcUserSystem>> getUserSystems(String serverUrl, Map<String, String> headerMap) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        Result<List<RpcUserSystem>> result = HttpUtils.getHttpList(serverUrl + "/user/getUserSystems", paramMap, headerMap, RpcUserSystem.class);
        return result;
    }

    public static Result<List<RpcSysOrganization>> getOrgTree(String serverUrl, Map<String, String> headerMap) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        Result<List<RpcSysOrganization>> result = HttpUtils.getHttpList(serverUrl + "/organization/queryTree", paramMap, headerMap, RpcSysOrganization.class);
        return result;
    }

    public static Result<RpcSysOrganization> getOrgInfo(String serverUrl, String id, String filterParam, Map<String, String> headerMap) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("id", id);
        paramMap.put("filterParam", filterParam);
        Result<RpcSysOrganization> result = HttpUtils.getHttp(serverUrl + "/organization/findOne", paramMap, headerMap, RpcSysOrganization.class);
        return result;
    }

    public static Result<List<RpcSysOrganization>> getChildOrg(String serverUrl, String pid, Map<String, String> headerMap) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (StrUtil.isBlank((CharSequence)pid)) {
            return Result.createSuccess(new ArrayList());
        }
        paramMap.put("filterParam", "pid_EQ_" + pid);
        Result<List<RpcSysOrganization>> result = HttpUtils.getHttpList(serverUrl + "/organization/queryList", paramMap, headerMap, RpcSysOrganization.class);
        return result;
    }

    public static Result<List<RpcSysUser>> getRelUsers(String serverUrl, String id, Map<String, String> headerMap) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("orgId", id);
        Result<List<RpcSysUser>> result = HttpUtils.postHttpList(serverUrl + "/organization/users", paramMap, headerMap, null, RpcSysUser.class);
        return result;
    }

    public static Result<List<RpcSysRole>> queryRoleTree(String serverUrl, String filterParam, Map<String, String> headerMap) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("filterParam", filterParam);
        Result<List<RpcSysRole>> result = HttpUtils.getHttpList(serverUrl + "/role/queryTree", paramMap, headerMap, RpcSysRole.class);
        return result;
    }

    public static Result<List<RpcSysRole>> queryRoleList(String serverUrl, String filterParam, Map<String, String> headerMap) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("filterParam", filterParam);
        Result<List<RpcSysRole>> result = HttpUtils.postHttpList(serverUrl + "/role/list", paramMap, headerMap, null, RpcSysRole.class);
        return result;
    }

    public static Result<List<RpcSysUser>> queryRoleUsers(String serverUrl, String roleId, Map<String, String> headerMap) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("roleId", roleId);
        Result<List<RpcSysUser>> result = HttpUtils.postHttpList(serverUrl + "/role/users", paramMap, headerMap, null, RpcSysUser.class);
        return result;
    }

    public static Result<RpcPage<RpcSysRole>> queryRolePage(String serverUrl, String filterParam, Integer page, Integer size, Map<String, String> headerMap) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        paramMap.put("filterParam", filterParam);
        paramMap.put("page", page.toString());
        paramMap.put("size", size.toString());
        Result<RpcPage<RpcSysRole>> result = HttpUtils.getHttpPage(serverUrl + "/role/queryPage", paramMap, headerMap, RpcSysRole.class);
        return result;
    }

    public static Result<RpcPage<RpcSysTenant>> queryTenantPage(String serverUrl, String filterParam, Integer page, Integer size, Map<String, String> headerMap) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        paramMap.put("filterParam", filterParam);
        paramMap.put("page", page.toString());
        paramMap.put("size", size.toString());
        Result<RpcPage<RpcSysTenant>> result = HttpUtils.getHttpPage(serverUrl + "/tenant/queryPage", paramMap, headerMap, RpcSysTenant.class);
        return result;
    }

    public static Result<RpcSystemInfoDTO> querySystemInfoByKey(String serverUrl, String systemKey, Map<String, String> headerMap) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("systemKey", systemKey);
        paramMap.put("key", systemKey);
        Result<RpcSystemInfoDTO> result = HttpUtils.getHttp(serverUrl + "/system/queryInfoByKey", paramMap, headerMap, RpcSystemInfoDTO.class);
        return result;
    }

    public static Result<List<RpcSysSubFunction>> querySubFunctionsByMenuId(String serverUrl, String roleId, String menuId, Map<String, String> headerMap) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("menuId", menuId);
        Result<List<RpcSysSubFunction>> result = HttpUtils.getHttpList(serverUrl + "/system/querySubFunctions", paramMap, headerMap, RpcSysSubFunction.class);
        return result;
    }
}

